/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule.caesium;

import com.atlassian.confluence.impl.util.serialize.SecureClassLoaderAwareObjectInputStream;
import com.atlassian.confluence.impl.util.serialize.SecureObjectSerializer;
import com.atlassian.confluence.impl.util.serialize.exception.DisallowedClassException;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.util.ParameterMapSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SecureParameterMapSerializer
extends ParameterMapSerializer {
    private final SecureObjectSerializer objectSerializer;
    private final Set<String> fullAllowedClassNames;
    private static final List<String> DEFAULT_ALLOWED_CLASS_NAMES = Arrays.asList("com.google.common.collect.ImmutableMap$SerializedForm", "com.google.common.collect.ImmutableBiMap$SerializedForm", "[Ljava.lang.Object;");

    public SecureParameterMapSerializer(Set<String> parameterClassAllowList) {
        this.fullAllowedClassNames = new HashSet<String>(parameterClassAllowList);
        this.fullAllowedClassNames.addAll(DEFAULT_ALLOWED_CLASS_NAMES);
        this.objectSerializer = new SecureObjectSerializer(this.fullAllowedClassNames, SecureParameterMapSerializer.class.getClassLoader());
    }

    public byte[] serializeParameters(@Nullable Map<String, Serializable> parameters) throws SchedulerServiceException {
        if (parameters == null) {
            return null;
        }
        HashMap<String, Serializable> parameterMap = new HashMap<String, Serializable>(parameters);
        byte[] serialized = this.objectSerializer.serialize(parameterMap);
        try {
            this.objectSerializer.deserialize(serialized, Map.class);
        }
        catch (DisallowedClassException e) {
            throw new SchedulerServiceException("Unexpected class: " + e.getDisallowedClass() + ". For security reason, only these class types are allowed in clustered job parameters: " + String.valueOf(this.fullAllowedClassNames));
        }
        return serialized;
    }

    protected ObjectInputStream createObjectInputStream(ClassLoader classLoader, byte[] parameters) throws IOException {
        return new SecureClassLoaderAwareObjectInputStream(classLoader, parameters, this.fullAllowedClassNames::contains);
    }
}

