/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule.jobs;

import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.ReflectionException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.core.io.ClassPathResource;

class JmxLoggingHelper {
    private static final MBeanServer M_BEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final String DEFAULT_TOMCAT_ENGINE_NAME = "Catalina";
    private static final String QUERY_LABEL_REQUEST_PROCESSOR = "RequestProcessor";
    private static final String QUERY_LABEL_TOMCAT_MANAGER = "TomcatManager";
    private static final String QUERY_LABEL_THREADPOOL = "ThreadPool";
    private final ObjectMapper objectMapper = new DefaultObjectMapperProvider().getObjectMapper();

    JmxLoggingHelper() {
    }

    protected String getTomcatEngineName() throws MalformedObjectNameException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        return (String)M_BEAN_SERVER.getAttribute(M_BEAN_SERVER.queryNames(new ObjectName("*:type=Engine"), Query.anySubString(Query.attr("modelerType"), Query.value("org.apache.catalina.core.StandardEngine"))).iterator().next(), "name");
    }

    private List<InstrumentQuery> modifyTomcatQueries(InstrumentQuery[] queries, Logger log) {
        ArrayList<InstrumentQuery> modifiedQueries = new ArrayList<InstrumentQuery>();
        try {
            String engineName = this.getTomcatEngineName();
            if (!engineName.equalsIgnoreCase(DEFAULT_TOMCAT_ENGINE_NAME)) {
                for (InstrumentQuery instrumentQuery : queries) {
                    if (instrumentQuery.name.startsWith(DEFAULT_TOMCAT_ENGINE_NAME) && Stream.of(QUERY_LABEL_REQUEST_PROCESSOR, QUERY_LABEL_TOMCAT_MANAGER, QUERY_LABEL_THREADPOOL).anyMatch(label -> label.equalsIgnoreCase(instrumentQuery.label))) {
                        InstrumentQuery modifiedQuery = new InstrumentQuery(instrumentQuery.label, instrumentQuery.name.replace(DEFAULT_TOMCAT_ENGINE_NAME, engineName), instrumentQuery.attributes);
                        modifiedQueries.add(modifiedQuery);
                        continue;
                    }
                    modifiedQueries.add(instrumentQuery);
                }
            }
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            log.error("Error occurred while querying the JMX instrument info: {}", (Object)e.getMessage());
        }
        return modifiedQueries;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<InstrumentQuery> readQueriesFromConfig(String filename, Logger log) {
        try (InputStream in = new ClassPathResource(filename).getInputStream();){
            InstrumentQuery[] queries;
            InputStreamReader reader;
            block15: {
                List<InstrumentQuery> list;
                reader = new InputStreamReader(in, Charset.defaultCharset());
                try {
                    log.debug("Reading {}: {} bytes", (Object)filename, (Object)in.available());
                    queries = (InstrumentQuery[])this.objectMapper.readerForArrayOf(InstrumentQuery.class).readValue((Reader)reader);
                    List<InstrumentQuery> modifiedQueries = this.modifyTomcatQueries(queries, log);
                    if (modifiedQueries.isEmpty()) break block15;
                    log.debug("Number of queries found: {}", (Object)modifiedQueries.size());
                    list = modifiedQueries;
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ((Reader)reader).close();
                return list;
            }
            log.debug("Number of queries found: {}", (Object)queries.length);
            List<InstrumentQuery> list = List.of(queries);
            ((Reader)reader).close();
            return list;
        }
        catch (IOException | RuntimeException e) {
            log.warn("Couldn't read {}, JMX instruments will not be logged: {}", (Object)filename, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public void logQueryResults(InstrumentQuery instrumentQuery, Logger log) {
        try {
            instrumentQuery.tryInit();
            ArrayList<InstrumentResult> result = new ArrayList<InstrumentResult>();
            log.debug("Running query: Application Metrics");
            for (ObjectName objectName : instrumentQuery.objectNames) {
                AttributeList attributeList = M_BEAN_SERVER.getAttributes(objectName, instrumentQuery.attributes);
                result.add(new InstrumentResult(JmxLoggingHelper.getCurrentTimestamp(), instrumentQuery.label, objectName.getCanonicalName(), attributeList.asList()));
            }
            log.info("{}: {}", (Object)instrumentQuery.label, (Object)this.objectMapper.writeValueAsString(result));
        }
        catch (JsonProcessingException | InstanceNotFoundException | MalformedObjectNameException | ReflectionException e) {
            log.error("Error occurred while querying the JMX instrument info: {}", (Object)e.getMessage());
        }
    }

    private static String getCurrentTimestamp() {
        return String.valueOf(Instant.now().getEpochSecond());
    }

    static class InstrumentQuery {
        private final String label;
        private final String name;
        private final String[] attributes;
        private Set<ObjectName> objectNames;

        @JsonCreator
        public InstrumentQuery(@JsonProperty(value="label") String label, @JsonProperty(value="name") String name, @JsonProperty(value="attributes") String[] attributes) {
            this.label = label;
            this.name = name;
            this.attributes = Arrays.copyOf(attributes, attributes.length);
        }

        void tryInit() throws MalformedObjectNameException {
            if (CollectionUtils.isEmpty(this.objectNames)) {
                this.objectNames = M_BEAN_SERVER.queryNames(new ObjectName(this.name), null);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstrumentQuery that = (InstrumentQuery)o;
            return Objects.equals(this.label, that.label) && Objects.equals(this.name, that.name) && Arrays.equals(this.attributes, that.attributes);
        }

        public int hashCode() {
            int result = Objects.hash(this.label, this.name);
            result = 31 * result + Arrays.hashCode(this.attributes);
            return result;
        }
    }

    private static class InstrumentResult {
        private final String timestamp;
        private final String label;
        private final String objectName;
        private final List<Attribute> attributes;

        public InstrumentResult(String timestamp, String label, String objectName, List<Attribute> attributes) {
            this.timestamp = timestamp;
            this.label = label;
            this.objectName = objectName;
            this.attributes = attributes;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getLabel() {
            return this.label;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }
    }
}

