/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule.jobs;

import com.atlassian.confluence.impl.schedule.jobs.JmxLoggingHelper;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxLoggingJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger((String)"jmx-logger");
    private final JmxLoggingHelper helper = new JmxLoggingHelper();
    private final List<JmxLoggingHelper.InstrumentQuery> queries = this.helper.readQueriesFromConfig("jmx-log-config.json", log);

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest request) {
        this.queries.forEach(instrumentQuery -> this.helper.logQueryResults((JmxLoggingHelper.InstrumentQuery)instrumentQuery, log));
        return JobRunnerResponse.success((String)"JMX instruments have been flushed to atlassian-confluence-jmx.log");
    }
}

