/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule.jobs;

import com.atlassian.core.task.TaskQueue;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueueFlushJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(TaskQueueFlushJob.class);
    private final TaskQueue queue;

    public TaskQueueFlushJob(TaskQueue queue) {
        this.queue = queue;
    }

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest request) {
        if (this.queue.isFlushing()) {
            log.debug("Task queue {} was already being flushed - skipped this time", (Object)this.queue);
            return JobRunnerResponse.aborted((String)("Task queue " + String.valueOf(this.queue) + " was already being flushed"));
        }
        log.debug("Executing tasks for queue {}", (Object)this.queue);
        this.queue.flush();
        return JobRunnerResponse.success((String)("Executed tasks for queue " + String.valueOf(this.queue)));
    }
}

