/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.scheduler;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.impl.schedule.caesium.ConfluenceSchedulerService;
import com.atlassian.confluence.impl.schedule.caesium.SchedulerConfiguration;
import com.atlassian.confluence.schedule.listeners.ScheduledJobsListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.caesium.spi.ClusteredJobDao;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SchedulingContextConfig {
    private static final String ALLOWLIST_RESOURCE = "com/atlassian/confluence/impl/common/common-classes.allowlist";

    @Bean(destroyMethod="shutdown")
    @AvailableToPlugins(interfaces={SchedulerService.class, LifecycleAwareSchedulerService.class})
    public SchedulerService schedulerService(SchedulerConfiguration schedulerConfig, @Qualifier(value="schedulerRunDetailsDao") RunDetailsDao schedulerRunDetailsDao, @Qualifier(value="schedulerClusteredJobDao") ClusteredJobDao schedulerClusteredJobDao, @Qualifier(value="commonAllowedClassesForSerialisation") Set<String> commonAllowedClassesForSerialisation, @Qualifier(value="clusterLockService") ClusterLockService clusterLockService, @Qualifier(value="clusterManager") ClusterManager clusterManager, @Lazy ScheduledJobsListener scheduledJobsListener) {
        HashSet<String> allowedClasses = new HashSet<String>(commonAllowedClassesForSerialisation);
        allowedClasses.add("com.atlassian.confluence.impl.schedule.caesium.TimeoutPolicy");
        allowedClasses.add("com.atlassian.crowd.manager.directory.SynchronisationMode");
        return new ConfluenceSchedulerService(schedulerConfig, schedulerRunDetailsDao, schedulerClusteredJobDao, allowedClasses, clusterLockService, clusterManager, () -> scheduledJobsListener);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Bean
    public Set<String> commonAllowedClassesForSerialisation() {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(ALLOWLIST_RESOURCE);){
            Set set;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                set = reader.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
            }
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load allowed classes from com/atlassian/confluence/impl/common/common-classes.allowlist", e);
        }
    }
}

