/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search;

import com.atlassian.confluence.event.events.permission.ContentTreePermissionReindexEvent;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.SearchPlatform;
import com.atlassian.confluence.search.SearchPlatformConfig;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;

public class IndexerEventListener {
    private final ConfluenceIndexer indexer;
    private final ChangeIndexer changeIndexer;
    private final EventListenerRegistrar eventListenerRegistrar;
    private final SearchPlatformConfig searchPlatformConfig;

    IndexerEventListener(ConfluenceIndexer indexer, ChangeIndexer changeIndexer, EventListenerRegistrar eventListenerRegistrar, SearchPlatformConfig searchPlatformConfig) {
        this.indexer = indexer;
        this.changeIndexer = changeIndexer;
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.searchPlatformConfig = searchPlatformConfig;
    }

    @PostConstruct
    void registerListeners() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    void unregisterListeners() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onEvent(VisitorEvent event) {
        event.visit(this.indexer, this.changeIndexer);
    }

    @EventListener
    public void onContentTreePermissionReindexEvent(ContentTreePermissionReindexEvent event) {
        if (this.searchPlatformConfig.searchPlatform() == SearchPlatform.LUCENE) {
            this.indexer.reIndexExcludingDependentsAndChangeIndex(event.getContent());
        } else {
            this.indexer.reIndexPermissions(event.getContent());
        }
        this.changeIndexer.reIndexAllVersions(event.getContent());
    }

    public static interface VisitorEvent {
        public void visit(ConfluenceIndexer var1, ChangeIndexer var2);
    }
}

