/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.queue;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.dmz.hibernate.AnyTypeDaoInternal;
import com.atlassian.confluence.impl.search.queue.DocumentRetrieverFactory;
import com.atlassian.confluence.impl.search.queue.PrefetchAtlassianDocumentRetriever;
import com.atlassian.confluence.internal.index.lucene.PrefetchDocumentBuilder;
import com.atlassian.confluence.internal.search.ChangeDocumentIndexPolicy;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.internal.search.queue.JournalIndexTaskQueue;
import com.atlassian.confluence.internal.search.tasks.NoOpIndexTask;
import com.atlassian.confluence.search.ConfluenceIndexTask;
import com.atlassian.confluence.search.IndexFlushRequester;
import com.atlassian.confluence.search.queue.JournalEntryType;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeIndexTaskQueue
extends JournalIndexTaskQueue {
    private static final Logger log = LoggerFactory.getLogger(ChangeIndexTaskQueue.class);
    private final DocumentRetrieverFactory prefetchAtlassianDocumentHelper;

    public ChangeIndexTaskQueue(JournalService journalService, IndexTaskFactoryInternal indexTaskFactory, AnyTypeDaoInternal anyTypeDao, IndexFlushRequester indexFlushRequester, JournalIdentifier journalIdentifier, PrefetchDocumentBuilder prefetchedDocumentBuilder) {
        super(journalService, indexTaskFactory, anyTypeDao, indexFlushRequester, journalIdentifier);
        this.prefetchAtlassianDocumentHelper = new DocumentRetrieverFactory(anyTypeDao, prefetchedDocumentBuilder);
    }

    @Override
    protected Function<JournalEntry, ConfluenceIndexTask> prefetch(Iterable<JournalEntry> entries) {
        try {
            PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever = this.prefetchAtlassianDocumentHelper.buildDocumentRetriever(entries);
            return journalEntry -> this.toTask((JournalEntry)journalEntry, prefetchAtlassianDocumentRetriever);
        }
        catch (Exception e) {
            log.error("Failed to prefetch data for Change Index. Fill fallback to process journal entry one by one", (Throwable)e);
            return this::toTask;
        }
    }

    @Override
    protected ConfluenceIndexTask toTask(JournalEntry entry) {
        Optional<JournalEntryType> type = JournalEntryType.optionalFromId(entry.getType());
        if (type.isEmpty()) {
            log.error("Unsupported change index queue entry: {}", (Object)entry);
            return NoOpIndexTask.getChangeInstance();
        }
        return switch (JournalEntryType.valueOf(entry.getType())) {
            case JournalEntryType.ADD_CHANGE_DOCUMENT -> this.getTaskIfShouldIndex(entry, this.indexTaskFactory::createAddChangeDocumentTask);
            case JournalEntryType.REBUILD_CHANGE_DOCUMENTS -> this.getTaskIfShouldIndex(entry, this.indexTaskFactory::createRebuildChangeDocumentsIndexTask);
            case JournalEntryType.DELETE_CHANGE_DOCUMENTS, JournalEntryType.UNINDEX_SPACE_CHANGE, JournalEntryType.REINDEX_ALL_USERS_CHANGE, JournalEntryType.REINDEX_ALL_BLOGS_CHANGE, JournalEntryType.REINDEX_USERS_IN_GROUP_CHANGE, JournalEntryType.REINDEX_ALL_SPACES_CHANGE, JournalEntryType.UNINDEX_CONTENT_TYPE_CHANGE, JournalEntryType.NO_OP -> this.toCommonTask(type.get(), entry);
            default -> {
                log.error("Unsupported change index queue entry: {}", (Object)entry);
                yield NoOpIndexTask.getChangeInstance();
            }
        };
    }

    private ConfluenceIndexTask toTask(JournalEntry entry, PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever) {
        Optional<JournalEntryType> type = JournalEntryType.optionalFromId(entry.getType());
        if (!type.isPresent()) {
            log.error("Unsupported change index queue entry: {}", (Object)entry);
            return NoOpIndexTask.getChangeInstance();
        }
        return switch (JournalEntryType.valueOf(entry.getType())) {
            case JournalEntryType.ADD_CHANGE_DOCUMENT -> this.createIndexTaskPrefetchAware(entry, searchable -> this.indexTaskFactory.createAddChangeDocumentTask((Searchable)searchable, prefetchAtlassianDocumentRetriever), prefetchAtlassianDocumentRetriever);
            case JournalEntryType.REBUILD_CHANGE_DOCUMENTS -> this.createIndexTaskPrefetchAware(entry, this.indexTaskFactory::createRebuildChangeDocumentsIndexTask, prefetchAtlassianDocumentRetriever);
            case JournalEntryType.DELETE_CHANGE_DOCUMENTS, JournalEntryType.UNINDEX_SPACE_CHANGE, JournalEntryType.REINDEX_ALL_USERS_CHANGE, JournalEntryType.REINDEX_ALL_BLOGS_CHANGE, JournalEntryType.REINDEX_USERS_IN_GROUP_CHANGE, JournalEntryType.REINDEX_ALL_SPACES_CHANGE, JournalEntryType.UNINDEX_CONTENT_TYPE_CHANGE, JournalEntryType.NO_OP -> this.toCommonTask(type.get(), entry);
            default -> {
                log.error("Unsupported change index queue entry: {}", (Object)entry);
                yield NoOpIndexTask.getChangeInstance();
            }
        };
    }

    private ConfluenceIndexTask toCommonTask(JournalEntryType type, JournalEntry entry) {
        return switch (type) {
            case JournalEntryType.DELETE_CHANGE_DOCUMENTS -> this.indexTaskFactory.createDeleteChangeDocumentsIndexTask(entry.getMessage());
            case JournalEntryType.UNINDEX_SPACE_CHANGE -> this.indexTaskFactory.createUnIndexSpaceChangeIndexTask(entry.getMessage());
            case JournalEntryType.REINDEX_ALL_USERS_CHANGE -> this.indexTaskFactory.createReindexAllUsersChangeTask();
            case JournalEntryType.REINDEX_ALL_BLOGS_CHANGE -> this.indexTaskFactory.createReindexAllBlogsChangeTask();
            case JournalEntryType.REINDEX_USERS_IN_GROUP_CHANGE -> this.indexTaskFactory.createReindexUsersInGroupChangeTask(entry.getMessage());
            case JournalEntryType.REINDEX_ALL_SPACES_CHANGE -> this.indexTaskFactory.createReindexAllSpacesChangeTask();
            case JournalEntryType.UNINDEX_CONTENT_TYPE_CHANGE -> this.indexTaskFactory.createUnindexContentTypeChangeTask(entry.getMessage());
            case JournalEntryType.NO_OP -> NoOpIndexTask.getChangeInstance();
            default -> {
                log.error("Unsupported change index queue entry: {}", (Object)entry);
                yield NoOpIndexTask.getChangeInstance();
            }
        };
    }

    private ConfluenceIndexTask createIndexTaskPrefetchAware(JournalEntry entry, Function<Searchable, ConfluenceIndexTask> confluenceIndexTaskSupplier, PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever) {
        Optional<Searchable> searchableOptional = prefetchAtlassianDocumentRetriever.prefetchSearchable(entry);
        if (!prefetchAtlassianDocumentRetriever.isPrefetched(entry)) {
            log.debug("No prefetch searchable found for entry: {}", (Object)entry);
            return NoOpIndexTask.getContentInstance();
        }
        return confluenceIndexTaskSupplier.apply(searchableOptional.get());
    }

    @VisibleForTesting
    ConfluenceIndexTask getTaskIfShouldIndex(JournalEntry entry, Function<Searchable, ConfluenceIndexTask> taskFinder) {
        Searchable searchable = this.getSearchableFromEntry(entry);
        if (ChangeDocumentIndexPolicy.shouldIndex(searchable)) {
            return taskFinder.apply(searchable);
        }
        return NoOpIndexTask.getChangeInstance();
    }
}

