/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.queue;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.dmz.hibernate.AnyTypeDaoInternal;
import com.atlassian.confluence.impl.search.queue.DocumentRetrieverFactory;
import com.atlassian.confluence.impl.search.queue.PrefetchAtlassianDocumentRetriever;
import com.atlassian.confluence.internal.index.lucene.PrefetchDocumentBuilder;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.internal.search.queue.JournalIndexTaskQueue;
import com.atlassian.confluence.internal.search.tasks.NoOpIndexTask;
import com.atlassian.confluence.search.ConfluenceIndexTask;
import com.atlassian.confluence.search.IndexFlushRequester;
import com.atlassian.confluence.search.queue.JournalEntryType;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentIndexTaskQueue
extends JournalIndexTaskQueue {
    private static final Logger log = LoggerFactory.getLogger(ContentIndexTaskQueue.class);
    private final DocumentRetrieverFactory prefetchAtlassianDocumentHelper;

    public ContentIndexTaskQueue(JournalService journalService, IndexTaskFactoryInternal indexTaskFactory, AnyTypeDaoInternal anyTypeDao, IndexFlushRequester indexFlushRequester, JournalIdentifier journalIdentifier, PrefetchDocumentBuilder prefetchedDocumentBuilder) {
        super(journalService, indexTaskFactory, anyTypeDao, indexFlushRequester, journalIdentifier);
        this.prefetchAtlassianDocumentHelper = new DocumentRetrieverFactory(anyTypeDao, prefetchedDocumentBuilder);
    }

    @Override
    protected Function<JournalEntry, ConfluenceIndexTask> prefetch(Iterable<JournalEntry> entries) {
        try {
            PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever = this.prefetchAtlassianDocumentHelper.buildDocumentRetriever(entries);
            return journalEntry -> this.toTask((JournalEntry)journalEntry, prefetchAtlassianDocumentRetriever);
        }
        catch (Exception e) {
            log.error("Failed to prefetch data for Content Index. Fill fallback to process journal entry one by one", (Throwable)e);
            return this::toTask;
        }
    }

    @Override
    protected ConfluenceIndexTask toTask(JournalEntry entry) {
        Optional<JournalEntryType> type = JournalEntryType.optionalFromId(entry.getType());
        if (type.isEmpty()) {
            log.error("Unsupported content index queue entry: {}", (Object)entry);
            return NoOpIndexTask.getContentInstance();
        }
        return switch (type.get()) {
            case JournalEntryType.ADD_DOCUMENT -> this.indexTaskFactory.createAddDocumentTask(this.getSearchableFromEntry(entry));
            case JournalEntryType.UPDATE_DOCUMENT -> this.indexTaskFactory.createUpdateDocumentTask(this.getSearchableFromEntry(entry));
            case JournalEntryType.UPDATE_DOCUMENT_EXCLUDING_DEPENDENTS -> this.indexTaskFactory.createUpdateDocumentTask(this.getSearchableFromEntry(entry), false);
            case JournalEntryType.DELETE_DOCUMENT, JournalEntryType.UNINDEX_SPACE, JournalEntryType.REINDEX_ALL_USERS, JournalEntryType.REINDEX_USERS_IN_GROUP, JournalEntryType.REINDEX_ALL_SPACES, JournalEntryType.UNINDEX_CONTENT_TYPE, JournalEntryType.REINDEX_ALL_BLOGS, JournalEntryType.REINDEX_PERMISSIONS, JournalEntryType.INDEX_DRAFTS, JournalEntryType.NO_OP -> this.toCommonTask(type.get(), entry);
            default -> {
                log.error("Unsupported content index queue entry: {}", (Object)entry);
                yield NoOpIndexTask.getContentInstance();
            }
        };
    }

    private ConfluenceIndexTask toTask(JournalEntry entry, PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever) {
        Optional<JournalEntryType> type = JournalEntryType.optionalFromId(entry.getType());
        if (!type.isPresent()) {
            log.error("Unsupported content index queue entry: {}", (Object)entry);
            return NoOpIndexTask.getContentInstance();
        }
        return switch (type.get()) {
            case JournalEntryType.ADD_DOCUMENT -> this.createIndexTaskPrefetchAware(entry, searchable -> this.indexTaskFactory.createAddDocumentTask((Searchable)searchable, prefetchAtlassianDocumentRetriever), prefetchAtlassianDocumentRetriever);
            case JournalEntryType.UPDATE_DOCUMENT -> this.createIndexTaskPrefetchAware(entry, searchable -> this.indexTaskFactory.createUpdateDocumentTask((Searchable)searchable, prefetchAtlassianDocumentRetriever), prefetchAtlassianDocumentRetriever);
            case JournalEntryType.UPDATE_DOCUMENT_EXCLUDING_DEPENDENTS -> this.createIndexTaskPrefetchAware(entry, searchable -> this.indexTaskFactory.createUpdateDocumentTask((Searchable)searchable, prefetchAtlassianDocumentRetriever, false), prefetchAtlassianDocumentRetriever);
            case JournalEntryType.DELETE_DOCUMENT, JournalEntryType.UNINDEX_SPACE, JournalEntryType.REINDEX_ALL_USERS, JournalEntryType.REINDEX_USERS_IN_GROUP, JournalEntryType.REINDEX_ALL_SPACES, JournalEntryType.UNINDEX_CONTENT_TYPE, JournalEntryType.REINDEX_ALL_BLOGS, JournalEntryType.REINDEX_PERMISSIONS, JournalEntryType.INDEX_DRAFTS, JournalEntryType.NO_OP -> this.toCommonTask(type.get(), entry);
            default -> {
                log.error("Unsupported content index queue entry: {}", (Object)entry);
                yield NoOpIndexTask.getContentInstance();
            }
        };
    }

    private ConfluenceIndexTask toCommonTask(JournalEntryType type, JournalEntry entry) {
        return switch (type) {
            case JournalEntryType.DELETE_DOCUMENT -> this.indexTaskFactory.createDeleteDocumentTask(entry.getMessage());
            case JournalEntryType.UNINDEX_SPACE -> this.indexTaskFactory.createUnIndexSpaceContentIndexTask(entry.getMessage());
            case JournalEntryType.REINDEX_ALL_USERS -> this.indexTaskFactory.createReindexAllUsersContentTask();
            case JournalEntryType.REINDEX_USERS_IN_GROUP -> this.indexTaskFactory.createReindexUsersInGroupContentTask(entry.getMessage());
            case JournalEntryType.REINDEX_ALL_SPACES -> this.indexTaskFactory.createReindexAllSpacesContentTask();
            case JournalEntryType.UNINDEX_CONTENT_TYPE -> this.indexTaskFactory.createUnindexContentTypeContentTask(entry.getMessage());
            case JournalEntryType.REINDEX_ALL_BLOGS -> this.indexTaskFactory.createReindexAllBlogsContentTask();
            case JournalEntryType.INDEX_DRAFTS -> this.indexTaskFactory.createIndexDraftsTask();
            case JournalEntryType.REINDEX_PERMISSIONS -> this.indexTaskFactory.createReIndexPermissionsTask(this.getSearchableFromEntry(entry));
            case JournalEntryType.NO_OP -> NoOpIndexTask.getContentInstance();
            default -> {
                log.error("Unsupported content index queue entry: {}", (Object)entry);
                yield NoOpIndexTask.getContentInstance();
            }
        };
    }

    private ConfluenceIndexTask createIndexTaskPrefetchAware(JournalEntry entry, Function<Searchable, ConfluenceIndexTask> confluenceIndexTaskSupplier, PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever) {
        Optional<Searchable> searchableOptional = prefetchAtlassianDocumentRetriever.prefetchSearchable(entry);
        if (!prefetchAtlassianDocumentRetriever.isPrefetched(entry)) {
            log.debug("No prefetch searchable found for entry: {}", (Object)entry);
            return NoOpIndexTask.getContentInstance();
        }
        return confluenceIndexTaskSupplier.apply(searchableOptional.get());
    }
}

