/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.queue;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.dmz.hibernate.AnyTypeDaoInternal;
import com.atlassian.confluence.impl.search.queue.PrefetchAtlassianDocumentRetriever;
import com.atlassian.confluence.internal.index.lucene.PrefetchDocumentBuilder;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.core.util.ClassLoaderUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRetrieverFactory {
    private static Logger log = LoggerFactory.getLogger(DocumentRetrieverFactory.class);
    private final AnyTypeDaoInternal anyTypeDao;
    private final PrefetchDocumentBuilder prefetchDocumentBuilder;

    public DocumentRetrieverFactory(AnyTypeDaoInternal anyTypeDao, PrefetchDocumentBuilder prefetchDocumentBuilder) {
        this.anyTypeDao = anyTypeDao;
        this.prefetchDocumentBuilder = prefetchDocumentBuilder;
    }

    public PrefetchAtlassianDocumentRetriever buildDocumentRetriever(Iterable<JournalEntry> entries) {
        HashMultimap handlesByClassName = HashMultimap.create();
        HashMultimap idToJournalEntry = HashMultimap.create();
        HashMap prefetchedEntries = Maps.newHashMap();
        HashMap prefetchedDocumentBuilderByClass = Maps.newHashMap();
        HashMap searchablesByClass = Maps.newHashMap();
        List<HibernateHandle> handles = this.convertToHibernateHandles(entries, (Multimap<Long, JournalEntry>)idToJournalEntry);
        for (HibernateHandle handle2 : handles) {
            String className = handle2.getClassName();
            handlesByClassName.put((Object)className, (Object)handle2);
        }
        log.debug("There are {} handler classes", (Object)handlesByClassName.size());
        for (String className : handlesByClassName.keySet()) {
            try {
                ClassLoaderUtils.loadClass((String)className, this.getClass());
            }
            catch (ClassNotFoundException e) {
                log.warn("Can not resolve handles of type {}. For prefetch ", (Object)className);
                continue;
            }
            log.debug("Prefetching Searchable of type {}. Total Handle is {}", (Object)className, (Object)handlesByClassName.size());
            List<Long> ids = handlesByClassName.get((Object)className).stream().map(handle -> handle.getId()).collect(Collectors.toList());
            List searchables = this.anyTypeDao.findByIdsAndClassNameWithoutCleanSession(ids, className);
            log.debug("Prefetching Searchable of type {}. Total Searchable is {}", (Object)className, (Object)searchables.size());
            for (Searchable searchable : searchables) {
                if (searchable instanceof Spaced) {
                    try {
                        Hibernate.initialize((Object)((Spaced)searchable).getSpace());
                    }
                    catch (HibernateException e) {
                        log.warn("Could not find space for handle Id: " + searchable.getId(), (Throwable)e);
                        continue;
                    }
                }
                idToJournalEntry.get((Object)searchable.getId()).forEach(entry -> prefetchedEntries.put(entry, searchable));
            }
            searchablesByClass.put(className, searchables);
        }
        if (prefetchedEntries.keySet().size() < handles.size()) {
            log.debug("Could not prefetch all JournalEntry. This could cause by deleted Searchable. Prefetch {} and journal {}", (Object)prefetchedEntries.keySet().size(), (Object)handles.size());
        }
        for (String className : handlesByClassName.keySet()) {
            Collection searchables = (Collection)searchablesByClass.get(className);
            Function<Searchable, AtlassianDocument> prefetchedDocumentBuilder = this.prefetchDocumentBuilder.createPrefetchedDocumentBuilder(searchables, className);
            prefetchedDocumentBuilderByClass.put(className, prefetchedDocumentBuilder);
        }
        return new PrefetchDocumentRetriver(prefetchedEntries, prefetchedDocumentBuilderByClass);
    }

    @VisibleForTesting
    List<HibernateHandle> convertToHibernateHandles(Iterable<JournalEntry> entries, Multimap<Long, JournalEntry> idToJournalEntry) {
        ArrayList<HibernateHandle> hibernateHandles = new ArrayList<HibernateHandle>();
        for (JournalEntry entry : entries) {
            try {
                HibernateHandle handle = new HibernateHandle(entry.getMessage());
                idToJournalEntry.put((Object)handle.getId(), (Object)entry);
                hibernateHandles.add(handle);
            }
            catch (Exception e) {
                log.debug("Could not parse journal entry id {}. We will skip it", (Object)entry.getId(), (Object)e);
            }
        }
        return hibernateHandles;
    }

    private static class PrefetchDocumentRetriver
    implements PrefetchAtlassianDocumentRetriever {
        private final Map<String, Function<Searchable, AtlassianDocument>> prefetchedDocumentBuilderByClass;
        private final Map<JournalEntry, Searchable> prefetchedEntries;

        PrefetchDocumentRetriver(Map<JournalEntry, Searchable> prefetchedEntries, Map<String, Function<Searchable, AtlassianDocument>> prefetchedDocumentsByClass) {
            this.prefetchedEntries = prefetchedEntries;
            this.prefetchedDocumentBuilderByClass = prefetchedDocumentsByClass;
        }

        @Override
        public boolean isPrefetched(JournalEntry journalEntry) {
            Optional<Searchable> searchableOptional = this.prefetchSearchable(journalEntry);
            if (searchableOptional.isEmpty()) {
                return false;
            }
            Searchable searchable = searchableOptional.get();
            Function<Searchable, AtlassianDocument> prefetchDocument = this.prefetchedDocumentBuilderByClass.get(Hibernate.getClass((Object)searchable).getName());
            return prefetchDocument != null;
        }

        @Override
        public Optional<AtlassianDocument> prefetch(JournalEntry journalEntry) {
            Optional<Searchable> searchable = this.prefetchSearchable(journalEntry);
            if (searchable.isEmpty()) {
                return Optional.empty();
            }
            return this.prefetch(searchable.get());
        }

        @Override
        public Optional<AtlassianDocument> prefetch(Searchable searchable) {
            if (searchable == null) {
                log.debug("Searchable is null");
                return Optional.empty();
            }
            Function<Searchable, AtlassianDocument> prefetchDocument = this.prefetchedDocumentBuilderByClass.get(Hibernate.getClass((Object)searchable).getName());
            return Optional.ofNullable(prefetchDocument.apply(searchable));
        }

        @Override
        public Optional<Searchable> prefetchSearchable(JournalEntry journalEntry) {
            return Optional.ofNullable(this.prefetchedEntries.get(journalEntry));
        }
    }
}

