/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2;

import com.atlassian.confluence.dmz.security.access.AccessDenied;
import com.atlassian.confluence.impl.security.query.SpacePermissionQueryBuilder;
import com.atlassian.confluence.impl.security.query.SpacePermissionQueryManager;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SpacePermissionQueryFactory;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.FieldExistsQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.confluence.search.v2.query.TermSetQuery;
import com.atlassian.confluence.security.denormalisedpermissions.BulkPermissionService;
import com.atlassian.confluence.user.ConfluenceUser;
import io.atlassian.fugue.Either;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultSpacePermissionQueryFactory
implements SpacePermissionQueryFactory {
    private final SpacePermissionQueryManager spacePermissionQueryManager;
    private final BulkPermissionService bulkPermissionService;

    public DefaultSpacePermissionQueryFactory(SpacePermissionQueryManager spacePermissionQueryManager, BulkPermissionService bulkPermissionService) {
        this.spacePermissionQueryManager = Objects.requireNonNull(spacePermissionQueryManager);
        this.bulkPermissionService = Objects.requireNonNull(bulkPermissionService);
    }

    @Override
    public SearchQuery create(@Nullable ConfluenceUser user) {
        Either<AccessDenied, SpacePermissionQueryBuilder> permissionQueryBuilderEither = this.spacePermissionQueryManager.createSpacePermissionQueryBuilder(user, "VIEWSPACE");
        return (SearchQuery)permissionQueryBuilderEither.map(this::createSpacePermissionQuery).getOrElse((Object)MatchNoDocsQuery.getInstance());
    }

    private SearchQuery createSpacePermissionQuery(SpacePermissionQueryBuilder queryBuilder) {
        Map<String, Boolean> allSpaces = this.bulkPermissionService.getAllSpaceKeysWithPermissionStatuses(queryBuilder.getUser(), queryBuilder.getPermissionType());
        HashSet<String> permittedSpaceKeys = new HashSet<String>();
        HashSet<String> unpermittedSpaceKeys = new HashSet<String>();
        allSpaces.forEach((space, hasAccess) -> {
            if (Boolean.TRUE.equals(hasAccess)) {
                permittedSpaceKeys.add((String)space);
            } else {
                unpermittedSpaceKeys.add((String)space);
            }
        });
        if (permittedSpaceKeys.size() <= unpermittedSpaceKeys.size()) {
            return (SearchQuery)BooleanQuery.builder().addShould(FieldExistsQuery.fieldNotExistsQuery(SearchFieldMappings.SPACE_KEY.getName())).addShould(new TermSetQuery(SearchFieldMappings.SPACE_KEY.getName(), permittedSpaceKeys)).build();
        }
        return (SearchQuery)BooleanQuery.builder().addMustNot(new TermSetQuery(SearchFieldMappings.SPACE_KEY.getName(), unpermittedSpaceKeys)).build();
    }
}

