/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2.extractor;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.labels.EditableLabelable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchableAttachment;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.PersonalInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class TitleExtractor
implements Extractor2 {
    @Override
    public StringBuilder extractText(Object searchable) {
        return new StringBuilder();
    }

    @Override
    public Collection<FieldDescriptor> extractFields(Object searchable) {
        if (!(searchable instanceof EditableLabelable)) {
            return Collections.emptyList();
        }
        String titleText = searchable instanceof Comment || searchable instanceof CustomContentEntityObject || searchable instanceof PersonalInformation || searchable instanceof SpaceDescription ? ((Addressable)searchable).getDisplayTitle() : (searchable instanceof Attachment ? ((SearchableAttachment)searchable).getFileName() : ((EditableLabelable)searchable).getTitle());
        if (StringUtils.isBlank((CharSequence)titleText)) {
            return Collections.emptyList();
        }
        ArrayList<FieldDescriptor> descriptors = new ArrayList<FieldDescriptor>();
        if (searchable instanceof Comment) {
            descriptors.add(SearchFieldMappings.DISPLAY_TITLE.createField(titleText));
        } else {
            descriptors.add(SearchFieldMappings.TITLE.createField(titleText));
            if (searchable instanceof Attachment) {
                descriptors.add(SearchFieldMappings.EXACT_FILENAME.createField(titleText));
            } else {
                boolean shouldIndexExactTitleField = Boolean.getBoolean("atlassian.darkfeature.confluence.search.improvements.exact");
                if (shouldIndexExactTitleField) {
                    descriptors.add(SearchFieldMappings.EXACT_TITLE.createField(titleText));
                }
            }
        }
        return descriptors;
    }
}

