/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2.lucene;

import com.atlassian.confluence.impl.search.v2.lucene.EnglishAnalyzer;
import com.atlassian.confluence.impl.search.v2.lucene.analysis.analyzer.UserDictionaryFactory;
import com.atlassian.confluence.internal.search.v2.lucene.LuceneConstants;
import com.atlassian.confluence.search.SearchLanguage;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.ASCIILanguageAnalyzer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pl.PolishAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;

public class ConfluenceAnalyzer
extends AnalyzerWrapper {
    private GlobalSettingsManager globalSettingsManager;
    private final Map<SearchLanguage, Analyzer> analyzersMap;
    private static final Analyzer STANDARD_ANALYZER = new StandardAnalyzer(LuceneConstants.LUCENE_VERSION);

    public ConfluenceAnalyzer(GlobalSettingsManager globalSettingsManager, UserDictionaryFactory userDictionaryFactory) {
        this.globalSettingsManager = globalSettingsManager;
        HashMap<SearchLanguage, Object> analyzersMap = new HashMap<SearchLanguage, Object>();
        analyzersMap.put(SearchLanguage.ARABIC, new ArabicAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.BRAZILIAN, new ASCIILanguageAnalyzer((Analyzer)new BrazilianAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.CHINESE, new StandardAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.CJK, new CJKAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.CUSTOM_JAPANESE, new JapaneseAnalyzer(LuceneConstants.LUCENE_VERSION, userDictionaryFactory != null ? userDictionaryFactory.getUserDictionary() : null, JapaneseTokenizer.DEFAULT_MODE, JapaneseAnalyzer.getDefaultStopSet(), JapaneseAnalyzer.getDefaultStopTags()));
        analyzersMap.put(SearchLanguage.CZECH, new CzechAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.DANISH, new ASCIILanguageAnalyzer((Analyzer)new DanishAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.DUTCH, new ASCIILanguageAnalyzer((Analyzer)new DutchAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.ENGLISH, new ASCIILanguageAnalyzer((Analyzer)new EnglishAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.FINNISH, new ASCIILanguageAnalyzer((Analyzer)new FinnishAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.FRENCH, new ASCIILanguageAnalyzer((Analyzer)new FrenchAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.GERMAN, new GermanAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.GREEK, new GreekAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.HUNGARIAN, new ASCIILanguageAnalyzer((Analyzer)new HungarianAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.ITALIAN, new ASCIILanguageAnalyzer((Analyzer)new ItalianAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.NORWEGIAN, new ASCIILanguageAnalyzer((Analyzer)new NorwegianAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.PERSIAN, new PersianAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.POLISH, new ASCIILanguageAnalyzer((Analyzer)new PolishAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.ROMANIAN, new ASCIILanguageAnalyzer((Analyzer)new RomanianAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.RUSSIAN, new RussianAnalyzer(LuceneConstants.LUCENE_VERSION));
        analyzersMap.put(SearchLanguage.SPANISH, new ASCIILanguageAnalyzer((Analyzer)new SpanishAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.SWEDISH, new ASCIILanguageAnalyzer((Analyzer)new SwedishAnalyzer(LuceneConstants.LUCENE_VERSION)));
        analyzersMap.put(SearchLanguage.OTHER, STANDARD_ANALYZER);
        this.analyzersMap = Collections.unmodifiableMap(analyzersMap);
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        SearchLanguage indexingLanguage = SearchLanguage.fromString(this.globalSettingsManager.getGlobalSettings().getIndexingLanguage());
        return this.analyzersMap.getOrDefault(indexingLanguage, STANDARD_ANALYZER);
    }

    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return components;
    }
}

