/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2.lucene.analysis.analyzer.exact;

import com.atlassian.confluence.plugins.index.api.ExactAnalyzerDescriptor;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.pattern.PatternCaptureGroupTokenFilter;
import org.apache.lucene.util.Version;

public class ExactAnalyzer
extends Analyzer {
    private final Version version;
    private final Pattern regexPattern;

    public ExactAnalyzer(Version version) {
        this.version = version;
        this.regexPattern = ExactAnalyzerDescriptor.PATTERN_REMOVE_PUNCTUATION;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        NormalizeCharMap.Builder mapBuilder = new NormalizeCharMap.Builder();
        ArrayList<String> unicodeWhitespaces = new ArrayList<String>();
        unicodeWhitespaces.addAll(ExactAnalyzerDescriptor.UNICODE_WHITESPACES);
        unicodeWhitespaces.addAll(ExactAnalyzerDescriptor.LUCENE_UNICODE_WHITESPACES);
        unicodeWhitespaces.forEach(whiteSpace -> mapBuilder.add(whiteSpace, " "));
        reader = new MappingCharFilter(mapBuilder.build(), reader);
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer(this.version, reader);
        PatternCaptureGroupTokenFilter patternCaptureGroupTokenFilter = new PatternCaptureGroupTokenFilter((TokenStream)tokenizer, true, new Pattern[]{this.regexPattern});
        LowerCaseFilter result = new LowerCaseFilter(this.version, (TokenStream)patternCaptureGroupTokenFilter);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }
}

