/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2.lucene.filter;

import com.atlassian.confluence.impl.search.v2.lucene.filter.MatchAllDocsFilter;
import com.atlassian.confluence.impl.search.v2.lucene.filter.MultiTermFilter;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Filter;

public class BrowseUsersPermissionsFilterFactory {
    private static Filter cachedFilter = new CachingWrapperFilter(BrowseUsersPermissionsFilterFactory.createFilter());
    private final PermissionManager permissionManager;

    public BrowseUsersPermissionsFilterFactory(PermissionManager permissionManager) {
        this.permissionManager = Objects.requireNonNull(permissionManager);
    }

    public Filter create(ConfluenceUser currentUser) {
        if (!this.canBrowseUsers(currentUser)) {
            return cachedFilter;
        }
        return MatchAllDocsFilter.getInstance();
    }

    private boolean canBrowseUsers(ConfluenceUser user) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, User.class);
    }

    private static Filter createFilter() {
        MultiTermFilter multiTermFilter = new MultiTermFilter(true);
        multiTermFilter.addTerm(new Term(SearchFieldMappings.TYPE.getName(), "userinfo"));
        return multiTermFilter;
    }
}

