/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2.lucene.filter;

import com.atlassian.confluence.dmz.security.access.AccessDenied;
import com.atlassian.confluence.impl.search.v2.lucene.EmptyDocIdSet;
import com.atlassian.confluence.impl.search.v2.lucene.filter.SpaceFilter;
import com.atlassian.confluence.impl.search.v2.lucene.filter.SpacePermissionsFilter;
import com.atlassian.confluence.impl.search.v2.lucene.filter.TermFilter;
import com.atlassian.confluence.impl.security.query.SpacePermissionQueryBuilder;
import com.atlassian.confluence.impl.security.query.SpacePermissionQueryManager;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.security.denormalisedpermissions.BulkPermissionService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.user.User;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BooleanFilter;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacePermissionsFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(SpacePermissionsFilterFactory.class);
    private static Filter spaceLessFilter = new CachingWrapperFilter((Filter)new TermFilter(new Term(SearchFieldMappings.IN_SPACE.getName(), "false")));
    private static final DocIdSet EMPTY_DOCIDSET = new EmptyDocIdSet();
    private final SpacePermissionQueryManager spacePermissionQueryManager;
    private final BulkPermissionService bulkPermissionService;

    public SpacePermissionsFilterFactory(SpacePermissionQueryManager spacePermissionQueryManager, BulkPermissionService bulkPermissionService) {
        this.spacePermissionQueryManager = Objects.requireNonNull(spacePermissionQueryManager);
        this.bulkPermissionService = bulkPermissionService;
    }

    public SpacePermissionsFilter create(User currentUser) {
        ConfluenceUser confluenceUser = FindUserHelper.getUser(currentUser);
        Either<AccessDenied, SpacePermissionQueryBuilder> permissionQueryBuilderEither = this.spacePermissionQueryManager.createSpacePermissionQueryBuilder(confluenceUser, "VIEWSPACE");
        if (permissionQueryBuilderEither.isRight()) {
            return new SpacePermissionsFilter(spaceLessFilter, this.createPermittedSpacesFilter((SpacePermissionQueryBuilder)permissionQueryBuilderEither.right().get()));
        }
        return new SpacePermissionsFilter(this, (Filter)new BooleanFilter(), (Filter)new BooleanFilter()){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) {
                return EMPTY_DOCIDSET;
            }
        };
    }

    public static Filter getSpaceLessFilter() {
        return spaceLessFilter;
    }

    private Filter createPermittedSpacesFilter(SpacePermissionQueryBuilder queryBuilder) {
        StopWatch stopWatch = StopWatch.createStarted();
        Map<String, Boolean> allSpaces = this.bulkPermissionService.getAllSpaceKeysWithPermissionStatuses(queryBuilder.getUser(), queryBuilder.getPermissionType());
        Set<String> permittedSpaces = allSpaces.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        log.debug("getting all space keys took {} ms", (Object)stopWatch.getTime());
        Set<String> notPermittedSpaces = allSpaces.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
        return SpacePermissionsFilterFactory.createFilterFromPermittedOrNotPermittedSpaces(permittedSpaces, notPermittedSpaces);
    }

    private static Filter createFilterFromPermittedOrNotPermittedSpaces(Collection<String> permittedSpaceKeys, Collection<String> notPermittedSpaceKeys) {
        boolean NEGATE_ON = true;
        boolean NEGATE_OFF = false;
        return notPermittedSpaceKeys.size() < permittedSpaceKeys.size() ? SpaceFilter.createFilter(notPermittedSpaceKeys, true) : SpaceFilter.createFilter(permittedSpaceKeys, false);
    }
}

