/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2.mappers;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.impl.search.v2.lucene.analysis.analyzer.exact.ExactAnalyzer;
import com.atlassian.confluence.impl.search.v2.lucene.analysis.analyzer.exact.ExactFilenameAnalyzer;
import com.atlassian.confluence.impl.search.v2.lucene.analysis.analyzer.ngram.NGramAnalyzer;
import com.atlassian.confluence.impl.search.v2.mappers.LuceneAnalyzerMapper;
import com.atlassian.confluence.internal.search.v2.lucene.LuceneException;
import com.atlassian.confluence.plugins.index.api.ExactAnalyzerDescriptor;
import com.atlassian.confluence.plugins.index.api.ExactFilenameAnalyzerDescriptor;
import com.atlassian.confluence.plugins.index.api.KeywordAnalyzerDescriptor;
import com.atlassian.confluence.plugins.index.api.MappingAnalyzerDescriptor;
import com.atlassian.confluence.plugins.index.api.StandardAnalyzerDescriptor;
import com.atlassian.confluence.plugins.index.api.TwoGramAnalyzerDescriptor;
import com.atlassian.confluence.plugins.index.api.WhitespaceAnalyzerDescriptor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;

@Internal
public class ConfluenceLuceneAnalyzerMapper
implements LuceneAnalyzerMapper {
    private final Map<Class<? extends MappingAnalyzerDescriptor>, Analyzer> analyzerMap;

    public ConfluenceLuceneAnalyzerMapper() {
        this((Map<Class<? extends MappingAnalyzerDescriptor>, Analyzer>)ImmutableMap.of());
    }

    public ConfluenceLuceneAnalyzerMapper(Map<Class<? extends MappingAnalyzerDescriptor>, Analyzer> additionalAnalyzerMap) {
        this.analyzerMap = ImmutableMap.builder().put(StandardAnalyzerDescriptor.class, (Object)new StandardAnalyzer(Version.LUCENE_44)).put(WhitespaceAnalyzerDescriptor.class, (Object)new WhitespaceAnalyzer(Version.LUCENE_44)).put(KeywordAnalyzerDescriptor.class, (Object)new KeywordAnalyzer()).put(ExactFilenameAnalyzerDescriptor.class, (Object)new ExactFilenameAnalyzer(Version.LUCENE_44)).put(ExactAnalyzerDescriptor.class, (Object)new ExactAnalyzer(Version.LUCENE_44)).put(TwoGramAnalyzerDescriptor.class, (Object)new NGramAnalyzer(2, 2, false)).putAll(additionalAnalyzerMap).build();
    }

    @Override
    public Analyzer map(MappingAnalyzerDescriptor mappingAnalyzerDescriptor) {
        Optional<Analyzer> analyzer = Optional.ofNullable(this.analyzerMap.get(mappingAnalyzerDescriptor.getClass()));
        if (analyzer.isEmpty()) {
            throw new LuceneException(String.format("There is no Lucene analyzer mapped for the descriptor: %s", mappingAnalyzerDescriptor.getClass()));
        }
        return analyzer.get();
    }
}

