/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.search.v2.mappers;

import com.atlassian.confluence.impl.search.v2.mappers.AbstractTextFieldQueryMapper;
import com.atlassian.confluence.internal.search.v2.DefaultAutoCorrectRawQueryTransformer;
import com.atlassian.confluence.internal.search.v2.LuceneAutoCorrectRawQueryParser;
import com.atlassian.confluence.internal.search.v2.lucene.LuceneQueryParserFactory;
import com.atlassian.confluence.internal.search.v2.lucene.LuceneQueryUtil;
import com.atlassian.confluence.search.v2.query.QueryStringQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStringQueryMapper
extends AbstractTextFieldQueryMapper<QueryStringQuery> {
    private static final Logger log = LoggerFactory.getLogger(QueryStringQueryMapper.class);
    private LuceneAutoCorrectRawQueryParser autoCorrectRawQueryTransformer;

    @Override
    public Query convertToLuceneQuery(QueryStringQuery query) {
        return this.autoCorrectRawQueryTransformer.parse(query, LuceneQueryUtil::safeEscape);
    }

    @Deprecated(since="8.9.0")
    public void setLuceneQueryParserFactory(LuceneQueryParserFactory luceneQueryParserFactory) {
        if (this.autoCorrectRawQueryTransformer == null) {
            this.setAutoCorrectRawQueryTransformer(new DefaultAutoCorrectRawQueryTransformer(luceneQueryParserFactory));
        }
    }

    public void setAutoCorrectRawQueryTransformer(LuceneAutoCorrectRawQueryParser autoCorrectRawQueryTransformer) {
        this.autoCorrectRawQueryTransformer = autoCorrectRawQueryTransformer;
    }
}

