/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.confluence.event.events.plugin.PluginFrameworkStartedEvent;
import com.atlassian.confluence.security.AllowedUrlsProvider;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowedUrlsProviderImpl
implements AllowedUrlsProvider {
    private static final Logger log = LoggerFactory.getLogger(AllowedUrlsProviderImpl.class);
    private final Supplier<ReadOnlyApplicationLinkService> readOnlyApplicationLinkServiceSupplier;
    private final Set<URI> urlsFromSystemProperty;
    private final AtomicBoolean isPluginFrameworkStarted = new AtomicBoolean();
    private final EventListenerRegistrar eventListenerRegistrar;
    private final BooleanSupplier isReadyToServe;

    public AllowedUrlsProviderImpl(EventListenerRegistrar eventListenerRegistrar) {
        this(eventListenerRegistrar, MemoizingComponentReference.osgiService(ReadOnlyApplicationLinkService.class), GeneralUtil::isReadyToServe);
    }

    @VisibleForTesting
    AllowedUrlsProviderImpl(EventListenerRegistrar eventListenerRegistrar, Supplier<ReadOnlyApplicationLinkService> readOnlyApplicationLinkServiceSupplier, BooleanSupplier isReadyToServe) {
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.readOnlyApplicationLinkServiceSupplier = readOnlyApplicationLinkServiceSupplier;
        this.isReadyToServe = isReadyToServe;
        this.urlsFromSystemProperty = this.getUrlsFromSystemProperty();
    }

    private Set<URI> getUrlsFromSystemProperty() {
        String allowedUrlsPropertyValue = System.getProperty("confluence.security.allowed.urls", "");
        if (StringUtils.isBlank((CharSequence)allowedUrlsPropertyValue)) {
            return Set.of();
        }
        log.debug("System property {} has value {}. Start converting values to URI.", (Object)"confluence.security.allowed.urls", (Object)allowedUrlsPropertyValue);
        try {
            return Arrays.stream(allowedUrlsPropertyValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(URI::create).collect(Collectors.toUnmodifiableSet());
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to parse system property {}, one of its values couldn't be converted to URI. System property value: {}", new Object[]{"confluence.security.allowed.urls", allowedUrlsPropertyValue, e});
            throw e;
        }
    }

    @PostConstruct
    public void registerEventListener() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    public void unregisterEventListener() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.isPluginFrameworkStarted.set(true);
    }

    @Override
    public Collection<URI> getUrls() {
        if (!this.isReadyToServe.getAsBoolean() || !this.isPluginFrameworkStarted.get()) {
            return this.urlsFromSystemProperty;
        }
        return this.getUrlsInternal();
    }

    private Collection<URI> getUrlsInternal() {
        Set<URI> urls = this.getApplicationLinkUrls();
        urls.addAll(this.urlsFromSystemProperty);
        return urls;
    }

    private Set<URI> getApplicationLinkUrls() {
        HashSet<URI> appLinkUrls = new HashSet<URI>();
        for (ReadOnlyApplicationLink applicationLink : this.readOnlyApplicationLinkServiceSupplier.get().getApplicationLinks()) {
            appLinkUrls.add(applicationLink.getDisplayUrl());
        }
        return appLinkUrls;
    }
}

