/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.core.InMemoryBufferingConsumer;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.cluster.ClusterConfigurationUtils;
import com.atlassian.confluence.event.events.security.SecretDeletedEvent;
import com.atlassian.confluence.event.events.security.SecretUpdatedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceConfiguration;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.SecretServiceFactory;
import com.atlassian.secrets.service.SecretServiceParams;
import com.atlassian.secrets.service.dao.MultiFileSecretDao;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSecretService
implements SecretService {
    public static final String SECRET_PLACEHOLDER = "{ATL_SECURED}";
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSecretService.class);
    private final InMemoryBufferingConsumer<Object> eventBuffer = new InMemoryBufferingConsumer(this::getEventConsumer, 100, this::bufferFull);
    private final ResettableLazyReference<SecretService> delegate;
    private final Supplier<EventPublisher> eventPublisher;

    public ConfluenceSecretService() {
        this((ResettableLazyReference<SecretService>)Lazy.resettable(ConfluenceSecretService::buildSecretService), ConfluenceSecretService::getEventPublisher);
    }

    @VisibleForTesting
    ConfluenceSecretService(ResettableLazyReference<SecretService> delegate, Supplier<EventPublisher> eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    public void reset() {
        this.delegate.reset();
    }

    private static SecretService buildSecretService() {
        ApplicationConfiguration applicationConfig = (ApplicationConfiguration)BootstrapUtils.getBootstrapContext().getBean("applicationConfig");
        Path home = ClusterConfigurationUtils.getSharedHome(applicationConfig).toPath();
        log.debug("Building SecretService instance with home directory: {}", (Object)home);
        SecretServiceParams params = new SecretServiceParams.SecretServiceParamsBuilder().setHomeDirectory(home).setSecretDao((SecretDao)new MultiFileSecretDao(home)).setClusterLockServiceSupplier(() -> (ClusterLockService)ContainerManager.getComponent((String)"clusterLockService", ClusterLockService.class)).build();
        return SecretServiceFactory.getSecretService((SecretServiceParams)params);
    }

    private static EventPublisher getEventPublisher() {
        if (!ContainerManager.isContainerSetup()) {
            return null;
        }
        return (EventPublisher)ContainerManager.getComponent((String)"eventPublisher", EventPublisher.class);
    }

    private SecretService getSecretService() {
        SecretService secretService = (SecretService)this.delegate.get();
        Objects.requireNonNull(secretService, "Error building SecretService");
        return secretService;
    }

    public void put(String identifier, String secretData) throws SecretServiceException {
        String currentValue;
        SecretService secretService = this.getSecretService();
        Optional maybeCurrentValue = secretService.get(identifier);
        if (maybeCurrentValue.isPresent() && (currentValue = (String)maybeCurrentValue.get()).equals(secretData)) {
            this.eventBuffer.tryFlushBuffer();
            return;
        }
        secretService.put(identifier, secretData);
        this.eventBuffer.accept((Object)new SecretUpdatedEvent(identifier));
    }

    public Optional<String> get(String identifier) throws SecretServiceException {
        return this.getSecretService().get(identifier);
    }

    public void delete(String identifier) throws SecretServiceException {
        SecretService secretService = this.getSecretService();
        Optional maybeCurrentValue = secretService.get(identifier);
        if (maybeCurrentValue.isEmpty()) {
            this.eventBuffer.tryFlushBuffer();
            return;
        }
        secretService.delete(identifier);
        this.eventBuffer.accept((Object)new SecretDeletedEvent(identifier));
    }

    public SecretServiceConfiguration getConfiguration() {
        return this.getSecretService().getConfiguration();
    }

    public SecretService.SecretServiceManagement getManagement() {
        return this.getSecretService().getManagement();
    }

    private Optional<Consumer<Object>> getEventConsumer() {
        EventPublisher publisher = this.eventPublisher.get();
        if (publisher == null) {
            log.debug("EventPublisher not available, buffering the secret audit event");
            return Optional.empty();
        }
        return Optional.of(arg_0 -> ((EventPublisher)publisher).publish(arg_0));
    }

    private void bufferFull(Object event) {
        log.warn("Event buffer in SecretService is full, discarding event {}", event);
    }
}

