/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security;

import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.internal.ContentSecurityPolicy;
import com.atlassian.security.csp.api.internal.NonceService;
import com.atlassian.security.csp.spi.CspProvider;
import java.util.Collections;
import java.util.List;

public class ContentSecurityPolicyProvider
implements CspProvider {
    NonceService nonceService;

    public ContentSecurityPolicyProvider(NonceService nonceService) {
        this.nonceService = nonceService;
    }

    public ContentSecurityPolicy getPolicy() {
        try {
            String nonce = this.nonceService.getNonce();
            ContentSecurityPolicy.Builder cspBuilder = new ContentSecurityPolicy.Builder().addToDirective(CspDirective.SCRIPT_SRC, "'self'").addToDirective(CspDirective.SCRIPT_SRC, String.format("'nonce-%s'", nonce));
            return cspBuilder.build();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getExclusionPatterns() {
        return Collections.emptyList();
    }
}

