/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PermissionPredicates {
    private final PermissionManager permissionManager;
    public final java.util.function.Predicate<Object> CAN_VIEW = this.hasPermission(Permission.VIEW);

    public PermissionPredicates(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public Predicate<Object> hasPermission(final Permission permission) {
        return new Predicate<Object>(){

            public boolean apply(@Nullable Object page) {
                return PermissionPredicates.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), permission, page);
            }

            public String toString() {
                return "CAN " + String.valueOf(permission);
            }
        };
    }

    public <T> java.util.function.Predicate<? super T> andCanViewPredicate(java.util.function.Predicate<? super T> ... filters) {
        ArrayList filterList = new ArrayList(List.of(filters));
        filterList.add(this.CAN_VIEW);
        return arg -> filterList.stream().allMatch(p -> p.test(arg));
    }
}

