/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security;

import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.DarkFeatures;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.google.common.collect.Iterables;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacePermissionCachePrimer {
    private static final Logger log = LoggerFactory.getLogger(SpacePermissionCachePrimer.class);
    private static final String PREFIX = "confluence.cache.all.space.permissions";
    private final EventListenerRegistrar eventListenerRegistrar;
    private final Primeable spacePermissionManager;
    private final ScheduledExecutorService scheduledExecutorService;
    private final SpaceManager spaceManager;
    private final DarkFeaturesManager darkFeaturesManager;

    SpacePermissionCachePrimer(EventListenerRegistrar eventListenerRegistrar, Primeable spacePermissionManager, ScheduledExecutorService scheduledExecutorService, SpaceManager spaceManager, DarkFeaturesManager darkFeaturesManager) {
        this.eventListenerRegistrar = Objects.requireNonNull(eventListenerRegistrar);
        this.spacePermissionManager = Objects.requireNonNull(spacePermissionManager);
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
        this.spaceManager = Objects.requireNonNull(spaceManager);
        this.darkFeaturesManager = Objects.requireNonNull(darkFeaturesManager);
    }

    @PostConstruct
    public void registerForEvents() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    public void unregisterForEvents() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        if (!SpacePermissionCachePrimer.useCoarseGrainedCaching(this.darkFeaturesManager)) {
            return;
        }
        long jitterMillis = Long.getLong("confluenceStartEvent.publishJitterMillis", 10000L);
        long delayMillis = (long)(Math.random() * (double)jitterMillis);
        log.info("Priming space permission cache in {} ms", (Object)delayMillis);
        this.scheduledExecutorService.schedule(this::primeCache, delayMillis, TimeUnit.MILLISECONDS);
    }

    private void primeCache() {
        ListBuilder<Space> spaces = this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceStatus(SpaceStatus.CURRENT).withSpaceType(SpaceType.GLOBAL).build());
        this.spacePermissionManager.prime(Iterables.concat(spaces));
    }

    static boolean useCoarseGrainedCaching(DarkFeaturesManager darkFeaturesManager) {
        DarkFeatures siteDarkFeatures = darkFeaturesManager.getSiteDarkFeatures();
        return siteDarkFeatures.isFeatureEnabled("confluence.cache.all.space.permissions.enabled");
    }

    static interface Primeable
    extends SpacePermissionManager {
        public void prime(Iterable<? extends Space> var1);
    }
}

