/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.access;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.annotations.security.UnrestrictedAccess;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

final class AccessAnnotationIterator
implements Iterator<Class<? extends Annotation>> {
    private final List<Class<? extends Annotation>> sortedAnnotationList;
    private final boolean isContainAccessAnnotation;
    private static final Set<Class<? extends Annotation>> availableAnnotations = Set.of(UnrestrictedAccess.class, AnonymousSiteAccess.class, UnlicensedSiteAccess.class, LicensedOnly.class, SystemAdminOnly.class, AdminOnly.class);

    AccessAnnotationIterator(Set<Class<? extends Annotation>> annotationClassList) {
        this.sortedAnnotationList = annotationClassList.stream().sorted(new AccessAnnotationComparator()).collect(Collectors.toCollection(ArrayList::new));
        this.isContainAccessAnnotation = this.sortedAnnotationList.stream().anyMatch(availableAnnotations::contains);
    }

    @Override
    public boolean hasNext() {
        return this.isContainAccessAnnotation && !this.sortedAnnotationList.isEmpty();
    }

    @Override
    public Class<? extends Annotation> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no secure access annotation to iterate");
        }
        return this.sortedAnnotationList.remove(0);
    }

    private static class AccessAnnotationComparator
    implements Comparator<Class<? extends Annotation>> {
        private AccessAnnotationComparator() {
        }

        private int getScore(Class<? extends Annotation> annotation) {
            if (annotation.equals(SystemAdminOnly.class)) {
                return 1;
            }
            if (annotation.equals(AdminOnly.class)) {
                return 2;
            }
            if (annotation.equals(LicensedOnly.class)) {
                return 3;
            }
            if (annotation.equals(AnonymousSiteAccess.class)) {
                return 4;
            }
            if (annotation.equals(UnlicensedSiteAccess.class)) {
                return 5;
            }
            if (annotation.equals(UnrestrictedAccess.class)) {
                return 6;
            }
            return 7;
        }

        @Override
        public int compare(Class<? extends Annotation> annotation1, Class<? extends Annotation> annotation2) {
            int score1 = this.getScore(annotation1);
            int score2 = this.getScore(annotation2);
            return score1 - score2;
        }
    }
}

