/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface AnnotatedPermitChecker {
    public static final String ANNOTATED_PERMITTED_CHECKER_ATTR = "3af_annotated_permitted_checker";

    default public boolean verifyIsPermitted(Class<?> checkingClass, String checkingMethodName, Class<?> ... checkingMethodParameterTypes) {
        try {
            return this.verifyPermission(checkingClass, (Method)checkingClass.getMethod((String)checkingMethodName, checkingMethodParameterTypes)).permitted;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("action method [ {" + checkingMethodName + "} ] not found on [ " + checkingClass.getName() + " ]", e);
        }
    }

    public AccessPermission verifyPermission(Class<?> var1, Method var2);

    public record AccessPermission(boolean permitted, @Nullable Class<? extends Annotation> targetAnnotation) {
        public static AccessPermission granted() {
            return new AccessPermission(true, null);
        }

        public static AccessPermission denied() {
            return new AccessPermission(false, null);
        }
    }
}

