/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.access;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.confluence.impl.security.access.AccessAnnotationIterator;
import com.atlassian.confluence.impl.security.access.AnnotatedPermitChecker;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DefaultAnnotatedPermitChecker
implements AnnotatedPermitChecker {
    private final Collection<Class<? extends Annotation>> permittedAnnotationList;

    public DefaultAnnotatedPermitChecker(Collection<Class<? extends Annotation>> permittedAnnotationList) {
        this.permittedAnnotationList = Objects.requireNonNull(permittedAnnotationList);
    }

    @Override
    public AnnotatedPermitChecker.AccessPermission verifyPermission(Class<?> checkingClass, @Nullable Method method) {
        return this.verifyMethodIsPermitted(this.calculateOrderedAnnotatedElements(checkingClass, method));
    }

    private AnnotatedPermitChecker.AccessPermission verifyMethodIsPermitted(List<AnnotatedElement> annotatedElements) {
        for (AnnotatedElement annotatedElement : annotatedElements) {
            Optional<AnnotatedPermitChecker.AccessPermission> verificationResult = this.verificationResultSupplier(annotatedElement);
            if (!verificationResult.isPresent()) continue;
            return verificationResult.get();
        }
        return this.resultOf(LicensedOnly.class);
    }

    private Optional<AnnotatedPermitChecker.AccessPermission> verificationResultSupplier(AnnotatedElement annotatedElement) {
        Set<Class<? extends Annotation>> annotationClasses = Arrays.stream(annotatedElement.getDeclaredAnnotations()).map(Annotation::annotationType).collect(Collectors.toSet());
        return this.processDeclareAnnotatedElements(annotationClasses);
    }

    private Optional<AnnotatedPermitChecker.AccessPermission> processDeclareAnnotatedElements(Set<Class<? extends Annotation>> annotationClasses) {
        AccessAnnotationIterator iterator = new AccessAnnotationIterator(annotationClasses);
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(this.resultOf((Class<? extends Annotation>)iterator.next()));
    }

    private AnnotatedPermitChecker.AccessPermission resultOf(Class<? extends Annotation> targetAnnotation) {
        return new AnnotatedPermitChecker.AccessPermission(this.permittedAnnotationList.contains(targetAnnotation), targetAnnotation);
    }

    private List<AnnotatedElement> calculateOrderedAnnotatedElements(Class<?> actionClass, @Nullable Method actionMethod) {
        Class<?> actionClassDeclaringMethod;
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (actionMethod != null && actionClass.equals(actionClassDeclaringMethod = actionMethod.getDeclaringClass())) {
            resultBuilder.add((Object)actionMethod);
        }
        resultBuilder.add(actionClass);
        return resultBuilder.build();
    }
}

