/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.access;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAccessChecker {
    private static final Logger logger = LoggerFactory.getLogger(UserAccessChecker.class);
    private final Map<Class<? extends Annotation>, Predicate<ConfluenceUser>> checkingMap = ImmutableMap.builder().put(UnrestrictedAccess.class, currentUser -> true).put(UnlicensedSiteAccess.class, loginUser -> {
        AccessStatus accessStatus = confluenceAccessManager.getUserAccessStatus((ConfluenceUser)loginUser);
        return accessStatus.hasUnlicensedAuthenticatedAccess() || accessStatus.hasLicensedAccess();
    }).put(AnonymousSiteAccess.class, loginUser -> {
        AccessStatus accessStatus = confluenceAccessManager.getUserAccessStatus((ConfluenceUser)loginUser);
        return accessStatus.hasAnonymousAccess() || accessStatus.hasUnlicensedAuthenticatedAccess() || accessStatus.hasLicensedAccess();
    }).put(LicensedOnly.class, loginUser -> {
        AccessStatus accessStatus = confluenceAccessManager.getUserAccessStatus((ConfluenceUser)loginUser);
        return accessStatus.hasLicensedAccess();
    }).put(AdminOnly.class, permissionManager::isConfluenceAdministrator).put(SystemAdminOnly.class, permissionManager::isSystemAdministrator).build();

    public UserAccessChecker(ConfluenceAccessManager confluenceAccessManager, PermissionManager permissionManager) {
    }

    public Collection<Class<? extends Annotation>> getPermittedAnnotations(ConfluenceUser loginUser) {
        ArrayList<Class<? extends Annotation>> permittedAnnotations = new ArrayList<Class<? extends Annotation>>();
        for (Map.Entry<Class<? extends Annotation>, Predicate<ConfluenceUser>> entry : this.checkingMap.entrySet()) {
            if (!entry.getValue().test(loginUser)) continue;
            permittedAnnotations.add(entry.getKey());
        }
        return permittedAnnotations;
    }

    public boolean isAccessPermitted(Class<? extends Annotation> checkedAnnotation, ConfluenceUser loginUser) {
        Predicate<ConfluenceUser> accessChecker = this.checkingMap.get(checkedAnnotation);
        if (accessChecker == null) {
            logger.debug("Could not found any access checker for annotation {}. Access will be denied", (Object)(checkedAnnotation != null ? checkedAnnotation.getName() : "null annotation"));
            return false;
        }
        return accessChecker.test(loginUser);
    }
}

