/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.delegate;

import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.oauth2.scopes.api.Permission;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import io.atlassian.util.concurrent.Lazy;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import java.util.function.Supplier;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopesRequestCacheDelegateImpl
implements ScopesRequestCacheDelegate {
    private static final Logger log = LoggerFactory.getLogger(ScopesRequestCacheDelegateImpl.class);
    private final OsgiContainerManager osgiContainerManager;
    private final ScopesRequestCacheDelegate.Registrar registrar;
    private final Supplier<ServiceTracker<ScopesRequestCache, ScopesRequestCache>> scopesRequestCacheServiceTracker;

    public ScopesRequestCacheDelegateImpl(OsgiContainerManager osgiContainerManager, ScopesRequestCacheDelegate.Registrar registrar) {
        this.osgiContainerManager = osgiContainerManager;
        this.registrar = registrar;
        this.scopesRequestCacheServiceTracker = Lazy.supplier(() -> osgiContainerManager.getServiceTracker(ScopesRequestCache.class.getName()));
    }

    @PostConstruct
    public void injectIntoContextManager() {
        this.registrar.register(this);
    }

    @Override
    public boolean hasPermission(com.atlassian.confluence.security.Permission permission, Object target) {
        return permission == null || this.hasPermission(permission.toString(), target);
    }

    @Override
    public boolean hasPermission(String permission, Object target) {
        return permission == null || this.getScopeRequestCache().map(scopesRequestCache -> scopesRequestCache.hasPermission(Permission.permissionWithTarget((String)permission, (Object)target))).orElse(true) != false;
    }

    @Override
    public boolean isScopePermitted(String scope) {
        return scope == null || this.getScopeRequestCache().map(scopesRequestCache -> scopesRequestCache.isScopePermitted(scope)).orElse(false) != false;
    }

    @Override
    public Optional<String> getApplicationNameForRequest() {
        return this.getScopeRequestCache().flatMap(ScopesRequestCache::getApplicationNameForRequest);
    }

    @Override
    public Optional<ScopesRequestCache.RequestCache> getRequestCache() {
        return this.getScopeRequestCache().map(ScopesRequestCache::getRequestCache);
    }

    @Override
    public void setRequestCache(ScopesRequestCache.RequestCache requestCache) {
        this.getScopeRequestCache().ifPresent(scopesRequestCache -> scopesRequestCache.setRequestCache(requestCache));
    }

    @Override
    public void clearRequestCache() {
        this.getScopeRequestCache().ifPresent(ScopesRequestCache::clearRequestCache);
    }

    private Optional<ScopesRequestCache> getScopeRequestCache() {
        log.debug("Getting scope request cache");
        if (this.osgiContainerManager.isRunning()) {
            return Optional.ofNullable((ScopesRequestCache)this.scopesRequestCacheServiceTracker.get().getService());
        }
        return Optional.empty();
    }
}

