/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.login;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.admin.criteria.WritableDirectoryExistsCriteria;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.security.login.LoginPageFunctionalityService;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.upgrade.UpgradeManager;
import com.atlassian.confluence.user.SignupManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserAgentUtil;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Internal
public class DefaultLoginPageFunctionalityService
implements LoginPageFunctionalityService {
    private final ClusterManager clusterManager;
    private final UpgradeManager upgradeManager;
    private final GlobalSettingsManager globalSettingsManager;
    private final UserAccessor userAccessor;
    private final WritableDirectoryExistsCriteria writableDirectoryExistsCriteria;
    private final DarkFeaturesManager darkFeaturesManager;
    private final WebInterfaceManager webInterfaceManager;
    private final SignupManager signupManager;

    public DefaultLoginPageFunctionalityService(ClusterManager clusterManager, UpgradeManager upgradeManager, GlobalSettingsManager globalSettingsManager, UserAccessor userAccessor, WritableDirectoryExistsCriteria writableDirectoryExistsCriteria, DarkFeaturesManager darkFeaturesManager, WebInterfaceManager webInterfaceManager, SignupManager signupManager) {
        this.clusterManager = clusterManager;
        this.upgradeManager = upgradeManager;
        this.globalSettingsManager = globalSettingsManager;
        this.userAccessor = userAccessor;
        this.writableDirectoryExistsCriteria = writableDirectoryExistsCriteria;
        this.darkFeaturesManager = darkFeaturesManager;
        this.webInterfaceManager = webInterfaceManager;
        this.signupManager = signupManager;
    }

    @Override
    public boolean shouldIncludeRememberMe() {
        return (!this.clusterManager.isClustered() || Boolean.getBoolean("cluster.login.rememberme.enabled")) && !this.isMobileAppWebView();
    }

    @Override
    public boolean showForgottenPasswordHelp() {
        return this.upgradeManager.isUpgraded() && !this.globalSettingsManager.getGlobalSettings().isExternalUserManagement();
    }

    @Override
    public boolean isShowSignUp(String token) {
        if (!this.userAccessor.isLicensedToAddMoreUsers()) {
            return false;
        }
        if (!this.upgradeManager.isUpgraded()) {
            return false;
        }
        if (!this.writableDirectoryExistsCriteria.isMet()) {
            return false;
        }
        if (this.isUnifiedUserManagementEnabled()) {
            return this.isUnifiedUserManagementSignUpEnabled();
        }
        return !this.globalSettingsManager.getGlobalSettings().isDenyPublicSignup() || this.isValidToken(token);
    }

    @Override
    public String getSignupURL() {
        WebItemModuleDescriptor signupWebItem = DefaultLoginPageFunctionalityService.findSignupWebItem(this.webInterfaceManager.getDisplayableItems("system.user/anonymous", Collections.emptyMap()));
        if (signupWebItem != null) {
            return signupWebItem.getLink().getDisplayableUrl(ServletContextThreadLocal.getRequest(), signupWebItem.getContextProvider().getContextMap(Collections.emptyMap()));
        }
        return ServletContextThreadLocal.getRequest().getContextPath() + "/signup.action";
    }

    private static WebItemModuleDescriptor findSignupWebItem(List<? extends com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor> webItems) {
        for (com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor webItemModuleDescriptor : webItems) {
            if (!webItemModuleDescriptor.getKey().contains("signup")) continue;
            return (WebItemModuleDescriptor)webItemModuleDescriptor;
        }
        return null;
    }

    private boolean isMobileAppWebView() {
        return UserAgentUtil.isBrowserFamily((UserAgentUtil.BrowserFamily)UserAgentUtil.BrowserFamily.ATLASSIAN_MOBILE);
    }

    private boolean isUnifiedUserManagementEnabled() {
        return this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled("unified.usermanagement");
    }

    private boolean isUnifiedUserManagementSignUpEnabled() {
        for (com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor webItem : this.webInterfaceManager.getDisplayableItems("system.user/anonymous", Collections.emptyMap())) {
            if (!webItem.getKey().equals("signup-um")) continue;
            return true;
        }
        return false;
    }

    private boolean isValidToken(String token) {
        return !StringUtils.isBlank((CharSequence)token) && this.signupManager.canSignUpWith(token);
    }
}

