/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.login.dao;

import com.atlassian.confluence.impl.security.login.dao.UserLoginInfoDao;
import com.atlassian.confluence.security.persistence.dao.hibernate.UserLoginInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUserLoginInfoDao
implements UserLoginInfoDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateUserLoginInfoDao.class);
    private final SessionFactory sessionFactory;

    public HibernateUserLoginInfoDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public UserLoginInfo findOrCreateUserLoginInfoForUser(ConfluenceUser user) {
        UserLoginInfo existingUserInfo = this.lookupLoginInfo(user);
        return Objects.requireNonNullElseGet(existingUserInfo, () -> new UserLoginInfo(user));
    }

    @Override
    public void saveOrUpdate(UserLoginInfo loginAudit) {
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)loginAudit);
    }

    @Override
    public void deleteUserInfoFor(ConfluenceUser user) {
        this.lookupAllLoginInfoRecords(user).forEach(record -> this.sessionFactory.getCurrentSession().delete(record));
    }

    @Override
    public @Nullable UserLoginInfo lookupLoginInfo(ConfluenceUser user) {
        List<UserLoginInfo> records = this.lookupAllLoginInfoRecords(user);
        if (records.size() > 1) {
            log.debug("There are {} UserLoginInfo entries for the user {}. We expect only one so the latest one will be used.", (Object)records.size(), (Object)user.getName());
        }
        if (records.isEmpty()) {
            return null;
        }
        return records.get(0);
    }

    private List<UserLoginInfo> lookupAllLoginInfoRecords(ConfluenceUser user) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.la_getAuditInfoByUsername", UserLoginInfo.class).setCacheable(true).setParameter("user", (Object)user).list();
    }
}

