/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.recovery;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.impl.security.recovery.RecoveryUtil;
import com.atlassian.confluence.internal.health.JohnsonEventPredicates;
import com.atlassian.confluence.setup.johnson.JohnsonUtils;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(RecoveryContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        if (!this.shouldCheckRecovery()) {
            return;
        }
        if (RecoveryUtil.isRecoveryMode()) {
            log.info("Confluence is running under recovery mode.");
            ConfluenceUserDao userDao = (ConfluenceUserDao)ContainerManager.getComponent((String)"confluenceUserDao");
            ConfluenceUser user = userDao.findByUsername(RecoveryUtil.getRecoveryUsername());
            if (user == null) {
                user = new ConfluenceUserImpl(RecoveryUtil.getRecoveryUsername(), RecoveryUtil.getRecoveryUsername(), "");
                userDao.create(user);
                log.info("Recovery admin user is created.");
            }
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    private boolean shouldCheckRecovery() {
        AtlassianBootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        return bootstrapManager != null && bootstrapManager.isSetupComplete() && ContainerManager.isContainerSetup() && !this.johnsonHasErrors();
    }

    private boolean johnsonHasErrors() {
        return JohnsonUtils.eventExists((JohnsonEventContainer)Johnson.getEventContainer(), (Predicate)JohnsonEventPredicates.blocksStartup());
    }
}

