/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.security.recovery;

import com.atlassian.crowd.manager.recovery.SystemPropertyRecoveryModeService;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.Objects;
import java.util.Optional;

public class RecoveryUtil {
    public static String getRecoveryUsername() {
        if (RecoveryUtil.getSystemPropertyRecoveryModeService().isPresent()) {
            return RecoveryUtil.getSystemPropertyRecoveryModeService().get().getRecoveryUsername();
        }
        return null;
    }

    public static boolean isRecoveryMode() {
        if (RecoveryUtil.getSystemPropertyRecoveryModeService().isPresent()) {
            return RecoveryUtil.getSystemPropertyRecoveryModeService().get().isRecoveryModeOn();
        }
        return false;
    }

    public static boolean isRecoveryAdmin(User user) {
        return RecoveryUtil.isRecoveryMode() && user != null && Objects.equals(RecoveryUtil.getRecoveryUsername(), user.getName());
    }

    public static boolean isRecoveryAdmin(String username) {
        return RecoveryUtil.isRecoveryMode() && Objects.equals(RecoveryUtil.getRecoveryUsername(), username);
    }

    private static Optional<SystemPropertyRecoveryModeService> getSystemPropertyRecoveryModeService() {
        if (ContainerManager.isContainerSetup()) {
            try {
                return Optional.of((SystemPropertyRecoveryModeService)ContainerManager.getComponent((String)"recoveryModeService", SystemPropertyRecoveryModeService.class));
            }
            catch (ComponentNotFoundException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

