/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.seraph;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.seraph.AuthenticatorMetrics;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;

@UnrestrictedAccess
public class AuthenticatorMetricsFilter
extends HttpFilter {
    private final Supplier<EventPublisher> eventPublisherRef = MemoizingComponentReference.containerComponent("eventPublisher");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        AuthenticatorMetrics.resetThreadLocal();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (AuthenticatorMetrics.hasEvents()) {
                this.eventPublisher().ifPresent(AuthenticatorMetrics::publishEvents);
            }
        }
    }

    private Optional<EventPublisher> eventPublisher() {
        return ContainerManager.isContainerSetup() ? Optional.ofNullable(this.eventPublisherRef.get()) : Optional.empty();
    }
}

