/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.core.persistence.hibernate.ExceptionMonitorPredicates;
import com.atlassian.confluence.impl.profiling.ThreadLocalMethodHooks;
import com.atlassian.confluence.servlet.ServletRequestAttributes;
import io.atlassian.util.concurrent.Lazy;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public final class HibernateGetConnectionFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(HibernateGetConnectionFilter.class);
    private static final String ERROR_MESSAGE = "DB connection pool is exhausted; obtaining a new DB connection for this request is disallowed.";
    private final Supplier<Method> getConnectionMethodRef = Lazy.callable(() -> ConnectionProvider.class.getDeclaredMethod("getConnection", new Class[0]));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            if (HibernateGetConnectionFilter.shouldDisallowGetConnection(request)) {
                this.registerHook();
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ThreadLocalMethodHooks.unregisterHooks();
        }
    }

    private void registerHook() {
        log.debug("Registering callback to disallow this request from opening a DB connection");
        ThreadLocalMethodHooks.registerHook(this.getConnectionMethodRef.get(), (method, args, target) -> {
            throw new IllegalStateException(ERROR_MESSAGE);
        });
    }

    private static boolean shouldDisallowGetConnection(HttpServletRequest request) {
        return HibernateGetConnectionFilter.isHttp500Error(request) && ExceptionMonitorPredicates.shortCircuitRequestTester().test(request);
    }

    private static boolean isHttp500Error(HttpServletRequest request) {
        return Objects.equals(ServletRequestAttributes.getErrorStatusCode((ServletRequest)request), 500);
    }
}

