/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.settings;

import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.impl.plugin.settings.PluginSetting;
import com.atlassian.confluence.impl.plugin.settings.PluginSettingRepository;
import com.atlassian.confluence.impl.settings.EscapeUtils;
import com.atlassian.sal.core.pluginsettings.AbstractStringPluginSettings;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluencePluginSettings
extends AbstractStringPluginSettings
implements ExtendedPluginSettings {
    private static final Logger log = LoggerFactory.getLogger(ConfluencePluginSettings.class);
    private static final String STR_IDENTIFIER = "#java.lang.String";
    private static final String BOOL_IDENTIFIER = "#java.lang.Boolean";
    private static final String LONG_IDENTIFIER = "#java.lang.Long";
    private static final String INT_IDENTIFIER = "#java.lang.Integer";
    private static final String SET_IDENTIFIER = "#java.util.Set";
    private static final Object NOT_RECOGNIZED = new Object();
    private final PluginSettingRepository repository;
    private final String namespace;

    public ConfluencePluginSettings(PluginSettingRepository repository, String namespace) {
        this.repository = Objects.requireNonNull(repository);
        this.namespace = Objects.requireNonNull(namespace);
    }

    public Set<String> getKeys() {
        return this.repository.findKeysByNamespace(this.namespace);
    }

    public Object put(String key, Object value) {
        ConfluencePluginSettings.validateKeyValueConstraints(key, value);
        if ("".equals(value)) {
            return this.remove(key);
        }
        Object result = this.putCustomTypedValue(key, value);
        if (result != NOT_RECOGNIZED) {
            return result;
        }
        return super.put(key, value);
    }

    private Object putCustomTypedValue(String key, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return this.saveCustomTypedValue(key, str, STR_IDENTIFIER);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return this.saveCustomTypedValue(key, bool, BOOL_IDENTIFIER);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return this.saveCustomTypedValue(key, longValue, LONG_IDENTIFIER);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return this.saveCustomTypedValue(key, integer, INT_IDENTIFIER);
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            StringBuilder sb = new StringBuilder();
            Iterator i = set.iterator();
            while (i.hasNext()) {
                sb.append(EscapeUtils.escape(i.next().toString()));
                if (!i.hasNext()) continue;
                sb.append('\n');
            }
            return this.saveCustomTypedValue(key, sb.toString(), SET_IDENTIFIER);
        }
        return NOT_RECOGNIZED;
    }

    private Object saveCustomTypedValue(String key, Object value, String typeIdentifier) {
        Object got = this.get(key);
        this.putActual(key, typeIdentifier + "\n" + String.valueOf(value));
        return got;
    }

    public Object get(String key) {
        ConfluencePluginSettings.validateKey(key);
        Object got = super.get(key);
        if (!(got instanceof String)) {
            return got;
        }
        String val = (String)got;
        return ConfluencePluginSettings.getCustomTypedValue(val).orElseThrow(() -> new CorruptPluginSettingException("Unrecognized value type: " + val));
    }

    private static Optional<Object> getCustomTypedValue(String val) {
        if (val.startsWith(STR_IDENTIFIER)) {
            return Optional.of(val.substring(STR_IDENTIFIER.length() + 1));
        }
        if (val.startsWith(BOOL_IDENTIFIER)) {
            return Optional.of(Boolean.parseBoolean(val.substring(BOOL_IDENTIFIER.length() + 1)));
        }
        try {
            if (val.startsWith(INT_IDENTIFIER)) {
                return Optional.of(Integer.parseInt(val.substring(INT_IDENTIFIER.length() + 1)));
            }
            if (val.startsWith(LONG_IDENTIFIER)) {
                return Optional.of(Long.parseLong(val.substring(LONG_IDENTIFIER.length() + 1)));
            }
        }
        catch (NumberFormatException e) {
            throw new CorruptPluginSettingException("Unparsable number type value", e);
        }
        if (val.startsWith(SET_IDENTIFIER)) {
            String[] lines = val.split("\n");
            List<String> rawItems = Arrays.asList(lines).subList(1, lines.length);
            return Optional.of(rawItems.stream().map(EscapeUtils::unescape).collect(Collectors.toSet()));
        }
        return Optional.empty();
    }

    protected String getActual(String key) {
        return this.repository.findById(new PluginSetting.CompositeId(this.namespace, key)).map(PluginSetting::getValue).orElse(null);
    }

    protected void putActual(String key, String value) {
        Validate.inclusiveBetween((long)1L, (long)99000L, (long)value.length(), (String)"Serialized value cannot be longer than 99,000 characters");
        this.repository.save(new PluginSetting(this.namespace, key, value));
    }

    public Object remove(String key) {
        ConfluencePluginSettings.validateKey(key);
        try {
            return super.remove(key);
        }
        catch (CorruptPluginSettingException e) {
            log.warn("Existing value was corrupt, force-removing", (Throwable)e);
            this.removeActual(key);
            return null;
        }
    }

    protected void removeActual(String key) {
        this.repository.deleteById(new PluginSetting.CompositeId(this.namespace, key));
    }

    static void validateKeyValueConstraints(String key, Object val) {
        ConfluencePluginSettings.validateKey(key);
        Validate.isTrue((val == null || val instanceof List || val instanceof Set || val instanceof Map || val instanceof String || val instanceof Integer || val instanceof Long || val instanceof Boolean ? 1 : 0) != 0, (String)"Property type: '%s' not supported", (Object[])new Object[]{val != null ? val.getClass().getName() : "null"});
        if (val instanceof List) {
            List list = (List)val;
            for (Object e : list) {
                if (e instanceof String) continue;
                throw new IllegalArgumentException("List containing non-String or null object not supported: %s".formatted(e));
            }
        }
        if (val instanceof Set) {
            Set set = (Set)val;
            for (Object e : set) {
                if (e instanceof String) continue;
                throw new IllegalArgumentException("Set containing non-String or null object not supported: %s".formatted(e));
            }
        }
        if (val instanceof Map) {
            Map map = (Map)val;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("Map containing non-String or null key not supported: %s".formatted(entry.getKey()));
                }
                if (entry.getValue() instanceof String) continue;
                throw new IllegalArgumentException("Map containing non-String or null value not supported: %s".formatted(entry.getValue()));
            }
        }
    }

    private static void validateKey(String key) {
        Validate.isTrue((key != null ? 1 : 0) != 0, (String)"Key cannot be null", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)100L, (long)key.length(), (String)"Key cannot be longer than %s characters".formatted(100));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfluencePluginSettings that = (ConfluencePluginSettings)((Object)o);
        return Objects.equals(this.repository, that.repository) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.repository, this.namespace);
    }

    public static class CorruptPluginSettingException
    extends IllegalStateException {
        private CorruptPluginSettingException(String s) {
            super(s);
        }

        private CorruptPluginSettingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

