/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.settings;

import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.setup.settings.GlobalDescription;
import com.atlassian.confluence.setup.settings.GlobalDescriptionDao;
import com.atlassian.confluence.setup.settings.GlobalDescriptionManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultGlobalDescriptionManager
implements GlobalDescriptionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalDescriptionManager.class);
    private static final String GLOBAL_DESCRIPTION_RECORD_ID_BANDANA_KEY = "global-description.record-id";
    private final GlobalDescriptionDao globalDescriptionDao;
    private final PluginSettings globalSettings;
    private final EventPublisher eventPublisher;
    private final PlatformTransactionManager transactionManager;
    private final AtomicReference<Long> cachedGlobalDescriptionId = new AtomicReference();

    public DefaultGlobalDescriptionManager(GlobalDescriptionDao globalDescriptionDao, PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher, PlatformTransactionManager transactionManager) {
        this.globalDescriptionDao = Objects.requireNonNull(globalDescriptionDao);
        this.globalSettings = Objects.requireNonNull(pluginSettingsFactory).createGlobalSettings();
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.transactionManager = Objects.requireNonNull(transactionManager);
    }

    @PostConstruct
    public void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                DefaultGlobalDescriptionManager.this.validateAndFixGlobalDescriptionRecordIdInLongTermMemoryIfRequired();
            }
        });
    }

    private void validateAndFixGlobalDescriptionRecordIdInLongTermMemoryIfRequired() {
        GlobalDescription globalDescription;
        Long globalDescriptionRecordId = this.getRecordIdFromLongTermMemory();
        GlobalDescription globalDescription2 = globalDescription = globalDescriptionRecordId != null ? this.globalDescriptionDao.getGlobalDescriptionById(globalDescriptionRecordId) : null;
        if (globalDescription != null) {
            this.cachedGlobalDescriptionId.set(globalDescription.getId());
            return;
        }
        globalDescription = this.globalDescriptionDao.getGlobalDescription();
        if (globalDescription != null) {
            this.saveRecordIdIntoLongTermMemory(globalDescription.getId());
            this.cachedGlobalDescriptionId.set(globalDescription.getId());
        }
    }

    @Override
    public GlobalDescription getGlobalDescription() {
        GlobalDescription globalDescription;
        Long recordId = this.cachedGlobalDescriptionId.get();
        GlobalDescription globalDescription2 = globalDescription = recordId != null ? this.globalDescriptionDao.getGlobalDescriptionById(recordId) : null;
        if (globalDescription != null) {
            return globalDescription;
        }
        globalDescription = this.globalDescriptionDao.getGlobalDescription();
        if (globalDescription != null) {
            this.cachedGlobalDescriptionId.set(globalDescription.getId());
        }
        return globalDescription;
    }

    @Override
    public void updateGlobalDescription(GlobalDescription globalDescription) {
        GlobalDescription oldDescription = this.getGlobalDescription();
        if (oldDescription != null && oldDescription != globalDescription && globalDescription.getId() != oldDescription.getId()) {
            log.error("One GlobalDescription object already exists. The new one will not be saved.");
            log.debug("Attempt to create the second GlobalDescription object: ", new Throwable());
            return;
        }
        this.globalDescriptionDao.save(globalDescription);
    }

    public Long getRecordIdFromLongTermMemory() {
        return (Long)this.globalSettings.get(GLOBAL_DESCRIPTION_RECORD_ID_BANDANA_KEY);
    }

    public void saveRecordIdIntoLongTermMemory(long id) {
        this.globalSettings.put(GLOBAL_DESCRIPTION_RECORD_ID_BANDANA_KEY, (Object)id);
    }
}

