/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.settings;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.dmz.BandanaManagerInternal;
import com.atlassian.config.internal.ApplicationConfig;
import com.atlassian.confluence.cache.ThreadLocalCacheAccessor;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.upgrade.BuildNumberComparator;
import com.atlassian.confluence.upgrade.UpgradedFlag;
import com.atlassian.johnson.Johnson;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.CannotCreateTransactionException;

public class PluginSettingsGlobalSettingsManager
implements GlobalSettingsManager {
    private static final ThreadLocalCacheAccessor<Keys, Settings> CACHE_ACCESSOR = ThreadLocalCacheAccessor.newInstance();
    private static final Logger log = LoggerFactory.getLogger(PluginSettingsGlobalSettingsManager.class);
    public static final String SETTINGS = "atlassian.confluence.settings";
    private final ConfluenceJsonObjectMapper mapper = new ConfluenceJsonObjectMapper();
    private final BandanaManagerInternal bandanaManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final UpgradedFlag upgradedFlag;
    private final ApplicationConfig applicationConfig;
    private AtomicBoolean isPluginSettingsCreatedFlag = new AtomicBoolean(false);

    public PluginSettingsGlobalSettingsManager(BandanaManagerInternal bandanaManager, PluginSettingsFactory pluginSettingsFactory, UpgradedFlag upgradedFlag, ApplicationConfig applicationConfig) {
        this.pluginSettingsFactory = Objects.requireNonNull(pluginSettingsFactory);
        this.upgradedFlag = Objects.requireNonNull(upgradedFlag);
        this.bandanaManager = Objects.requireNonNull(bandanaManager);
        this.applicationConfig = Objects.requireNonNull(applicationConfig);
    }

    private boolean isPluginSettingsCreated() {
        if (!this.isPluginSettingsCreatedFlag.get()) {
            this.isPluginSettingsCreatedFlag.compareAndSet(false, new BuildNumberComparator().compare(this.applicationConfig.getBuildNumber(), "9403") >= 0);
        }
        return this.isPluginSettingsCreatedFlag.get();
    }

    @Override
    public Settings getGlobalSettings() {
        try {
            Settings settings = null;
            if (CACHE_ACCESSOR.isInit()) {
                settings = CACHE_ACCESSOR.get(Keys.GLOBAL_SETTINGS);
            }
            if (null == settings) {
                if (this.isPluginSettingsCreated()) {
                    String settingsJson = (String)this.pluginSettingsFactory.createGlobalSettings().get(SETTINGS);
                    settings = this.mapper.deserializeOrNull(settingsJson, Settings.class);
                } else {
                    settings = (Settings)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, SETTINGS);
                }
                if (null == settings) {
                    settings = new Settings();
                }
                if (CACHE_ACCESSOR.isInit()) {
                    CACHE_ACCESSOR.put(Keys.GLOBAL_SETTINGS, settings);
                }
            }
            return settings;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CannotCreateTransactionException && Johnson.getEventContainer().hasEvents()) {
                return Settings.unsavableSettings();
            }
            if (this.upgradedFlag.isUpgraded()) {
                throw e;
            }
            log.warn("Unable to retrieve settings object during upgrade. Returning read-only settings object just in case", (Throwable)e);
            return Settings.unsavableSettings();
        }
    }

    @Override
    public void updateGlobalSettings(Settings settings) {
        if (settings.isSaveable()) {
            if (this.isPluginSettingsCreated()) {
                this.pluginSettingsFactory.createGlobalSettings().put(SETTINGS, (Object)this.mapper.serialize(settings));
            } else {
                this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, SETTINGS, (Object)settings);
            }
            CACHE_ACCESSOR.flush();
        } else {
            log.error("Unable to save temporary settings object.", (Throwable)new RuntimeException("settings object marked read-only"));
        }
    }

    public static enum Keys {
        GLOBAL_SETTINGS;

    }
}

