/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.internal.ApplicationConfig;
import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceApplicationConfig
extends ApplicationConfig {
    public static final String SECURED_PROPERTIES = "secure.properties";
    public static final String SECURED_PROPERTIES_ENABLED = "true";
    public static final String OPEN_SEARCH_PASSWORD = "opensearch.password";
    static final String SETUP_STEP_NODE = "setupStep";
    static final String SETUP_TYPE_NODE = "setupType";
    static final String BUILD_NUMBER_NODE = "buildNumber";
    static final String PROPERTIES_NODE = "properties";
    private static final Logger log = LoggerFactory.getLogger(ConfluenceApplicationConfig.class);
    private static final Set<String> propertiesToSecure = Set.of("confluence.cluster.authentication.secret", "confluence.cluster.aws.access.key", "confluence.cluster.aws.secret.key", "opensearch.password", "hibernate.connection.password", "synchrony.service.authtoken");
    private final SecretService secretService;

    public ConfluenceApplicationConfig(SecretService secretService) {
        this.secretService = secretService;
    }

    public synchronized void load() throws ConfigurationException {
        this.configurationPersister.load(this.getApplicationHome(), this.getConfigurationFileName());
        this.setBuildNumber(this.configurationPersister.getStringConfigElement(BUILD_NUMBER_NODE));
        this.setSetupType(this.configurationPersister.getStringConfigElement(SETUP_TYPE_NODE));
        this.setCurrentSetupStep(this.configurationPersister.getStringConfigElement(SETUP_STEP_NODE));
        Map loadedProperties = (Map)this.configurationPersister.getConfigElement(Map.class, PROPERTIES_NODE);
        if (SecretService.getState() == SecretServiceState.ENABLED) {
            Object clusterHome = loadedProperties.get("confluence.cluster.home");
            if (clusterHome != null) {
                this.setProperty("confluence.cluster.home", clusterHome);
            }
            propertiesToSecure.forEach(securedProperty -> {
                Object value = loadedProperties.get(securedProperty);
                if ("{ATL_SECURED}".equals(value)) {
                    String secretId = this.getSecretId((String)securedProperty);
                    Optional maybeSecret = this.secretService.get(secretId);
                    if (maybeSecret.isEmpty()) {
                        throw new IllegalStateException(String.format("Secured property not found in SecretService %s", secretId));
                    }
                    loadedProperties.put(securedProperty, maybeSecret.get());
                }
            });
        }
        this.getProperties().putAll(loadedProperties);
    }

    public synchronized void save() throws ConfigurationException {
        HashMap<String, Object> propertiesCopy = new HashMap<String, Object>(this.getProperties());
        if (this.securePropertiesAreEnabled(propertiesCopy)) {
            propertiesToSecure.forEach(securedProperty -> {
                Object value = propertiesCopy.get(securedProperty);
                if (value == null) {
                    return;
                }
                if (!(value instanceof String)) {
                    log.warn("Confluence property '{}' is not a String so it cannot be stored within the SecretService", securedProperty);
                    return;
                }
                String secretValue = (String)value;
                this.secretService.put(this.getSecretId((String)securedProperty), secretValue);
                propertiesCopy.put((String)securedProperty, "{ATL_SECURED}");
            });
        }
        this.configurationPersister.clear();
        this.configurationPersister.addConfigElement((Object)this.getCurrentSetupStep(), SETUP_STEP_NODE);
        this.configurationPersister.addConfigElement((Object)this.getSetupType(), SETUP_TYPE_NODE);
        this.configurationPersister.addConfigElement((Object)this.getBuildNumber(), BUILD_NUMBER_NODE);
        this.configurationPersister.addConfigElement(new TreeMap<String, Object>(propertiesCopy), PROPERTIES_NODE);
        this.configurationPersister.save(this.getApplicationHome(), this.getConfigurationFileName());
    }

    public synchronized void setSetupComplete(boolean setupComplete) {
        if (!setupComplete && !SetupContext.isAvailable()) {
            throw new IllegalStateException("Can not mutate ApplicationConfig setupComplete state as false while not during setup process.");
        }
        super.setSetupComplete(setupComplete);
    }

    String getSecretId(String propertyName) {
        return String.format("confluence.property.%s", propertyName);
    }

    public static void enableSecureProperties(ApplicationConfiguration applicationConfiguration) {
        applicationConfiguration.setProperty((Object)SECURED_PROPERTIES, (Object)SECURED_PROPERTIES_ENABLED);
    }

    private boolean securePropertiesAreEnabled(Map<String, Object> properties) {
        if (SecretService.getState() != SecretServiceState.ENABLED) {
            return false;
        }
        Object enableSecuredPropertiesFlag = properties.get(SECURED_PROPERTIES);
        return SECURED_PROPERTIES_ENABLED.equals(enableSecuredPropertiesFlag);
    }
}

