/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup;

import com.atlassian.config.internal.lifecycle.DefaultLifecycleContext;
import com.atlassian.config.internal.lifecycle.LifecycleManager;
import com.atlassian.config.lifecycle.LifecycleContext;
import com.atlassian.config.lifecycle.LifecycleItem;
import com.atlassian.config.lifecycle.events.ApplicationStoppedEvent;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStoppingEvent;
import com.atlassian.confluence.impl.setup.LifecyclePluginModuleDescriptor;
import com.atlassian.confluence.internal.health.JohnsonEventLevel;
import com.atlassian.confluence.internal.health.JohnsonEventType;
import com.atlassian.confluence.setup.johnson.JohnsonUtils;
import com.atlassian.confluence.util.profiling.TimedAnalytics;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.profiling.Ticker;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycleManager
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultLifecycleManager.class);
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    private boolean startedUp;

    public DefaultLifecycleManager(EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    public void startUp(ServletContext servletContext) {
        try (Ticker ticker = TimedAnalytics.timedAnalytics().start("confluence.profiling.startup.lifecycle");){
            List<LifecyclePluginModuleDescriptor> moduleDescriptors = this.getLifecyclePluginModuleDescriptors();
            DefaultLifecycleContext context = new DefaultLifecycleContext(servletContext);
            LifecyclePluginModuleDescriptor currentDescriptor = null;
            try {
                Iterator<LifecyclePluginModuleDescriptor> iterator = moduleDescriptors.iterator();
                while (iterator.hasNext()) {
                    LifecyclePluginModuleDescriptor descriptor;
                    currentDescriptor = descriptor = iterator.next();
                    log.info("Starting: {}", (Object)descriptor);
                    ((LifecycleItem)descriptor.getModule()).startup((LifecycleContext)context);
                }
                this.eventPublisher.publish((Object)new com.atlassian.config.lifecycle.events.ApplicationStartedEvent((Object)this));
                this.eventPublisher.publish((Object)new ApplicationStartedEvent());
                this.startedUp = true;
            }
            catch (Throwable t) {
                this.panicAndShutdown(t, (LifecycleContext)context, currentDescriptor);
            }
        }
    }

    public void shutDown(ServletContext servletContext) {
        this.shutDown(servletContext, null);
    }

    public boolean isStartedUp() {
        return this.startedUp;
    }

    private void panicAndShutdown(Throwable t, LifecycleContext context, LifecyclePluginModuleDescriptor descriptor) {
        String errorString = "Unable to start up Confluence. Fatal error during startup sequence: " + String.valueOf(descriptor);
        log.error(errorString, t);
        JohnsonUtils.raiseJohnsonEvent((JohnsonEventType)JohnsonEventType.STARTUP, (String)errorString, (String)t.getMessage(), (JohnsonEventLevel)JohnsonEventLevel.FATAL);
        this.shutDown(context.getServletContext(), descriptor.getCompleteKey());
    }

    private void shutDown(ServletContext servletContext, String startingPluginKey) {
        this.eventPublisher.publish((Object)new ApplicationStoppingEvent());
        this.eventPublisher.publish((Object)new com.atlassian.config.lifecycle.events.ApplicationStoppingEvent((Object)this));
        List<LifecyclePluginModuleDescriptor> moduleDescriptors = this.getLifecyclePluginModuleDescriptors();
        Collections.reverse(moduleDescriptors);
        DefaultLifecycleContext context = new DefaultLifecycleContext(servletContext);
        boolean started = startingPluginKey == null;
        for (LifecyclePluginModuleDescriptor descriptor : moduleDescriptors) {
            if (!started) {
                if (!descriptor.getCompleteKey().equals(startingPluginKey)) continue;
                started = true;
            }
            log.info("Shutting down: {}", (Object)descriptor);
            LifecycleItem item = (LifecycleItem)descriptor.getModule();
            try {
                item.shutdown((LifecycleContext)context);
            }
            catch (Throwable t) {
                log.error("Error running shutdown plugin: {} - {}", new Object[]{descriptor.getDescription(), t, t});
            }
        }
        this.eventPublisher.publish((Object)new com.atlassian.confluence.event.events.lifecycle.ApplicationStoppedEvent());
        this.eventPublisher.publish((Object)new ApplicationStoppedEvent((Object)this));
    }

    private List<LifecyclePluginModuleDescriptor> getLifecyclePluginModuleDescriptors() {
        ArrayList<LifecyclePluginModuleDescriptor> modules = new ArrayList<LifecyclePluginModuleDescriptor>(this.pluginAccessor.getEnabledModuleDescriptorsByClass(LifecyclePluginModuleDescriptor.class));
        Collections.sort(modules);
        return modules;
    }
}

