/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup;

import com.atlassian.config.internal.lifecycle.ServletContextListenerWrapper;
import com.atlassian.config.lifecycle.LifecycleItem;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.ServletContextListener;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LifecyclePluginModuleDescriptor
extends AbstractModuleDescriptor
implements Comparable<LifecyclePluginModuleDescriptor> {
    private Object module;
    private int sequence;

    public LifecyclePluginModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.sequence = this.determineSequenceNumber(element);
    }

    private void ensureCompatibleModuleType() throws PluginParseException {
        Class moduleClass = this.getModuleClass();
        if (!LifecycleItem.class.isAssignableFrom(moduleClass) && !ServletContextListener.class.isAssignableFrom(moduleClass)) {
            throw new PluginParseException("Lifecycle classes must extend LifecycleItem or ServletContextListener. Module class: " + moduleClass.getName());
        }
    }

    private int determineSequenceNumber(Element element) throws PluginParseException {
        String value = element.attributeValue("sequence");
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new PluginParseException("Could not determine sequence from: " + value);
            }
        }
        throw new PluginParseException("Missing required attribute: sequence");
    }

    public Object getModule() {
        return this.module;
    }

    private Object makeModule() {
        Object module = ContainerManager.getInstance().getContainerContext().createComponent(this.getModuleClass());
        if (module instanceof ServletContextListener) {
            ServletContextListener listener = (ServletContextListener)module;
            module = new ServletContextListenerWrapper(listener);
        }
        return module;
    }

    public void enabled() {
        super.enabled();
        this.ensureCompatibleModuleType();
        this.module = this.makeModule();
        if (this.module instanceof StateAware) {
            ((StateAware)this.module).enabled();
        }
    }

    public void disabled() {
        if (this.module instanceof StateAware) {
            ((StateAware)this.module).disabled();
        }
        this.module = null;
        super.disabled();
    }

    public int getSequence() {
        return this.sequence;
    }

    @VisibleForTesting
    void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Override
    public int compareTo(LifecyclePluginModuleDescriptor o) {
        int otherSequence = o.sequence;
        return Integer.compare(this.sequence, otherSequence);
    }
}

