/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.impl.setup.PackageScannerConfigurationYamlReader;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@Configuration
public class PackageScannerConfigurationAppConfig {
    private static final Logger log = LoggerFactory.getLogger(PackageScannerConfigurationAppConfig.class);
    @Value(value="classpath:package-exports.yaml")
    Resource packageExportsResource;
    @Value(value="classpath:public-api.yaml")
    Resource publicApiResource;
    @Value(value="classpath:package-versions.properties")
    Resource packageVersionsResource;

    @Bean
    @AvailableToPlugins(value=PackageScannerConfiguration.class)
    PackageScannerConfiguration packageScanningConfiguration() throws IOException {
        DefaultPackageScannerConfiguration config = new DefaultPackageScannerConfiguration(BuildInformation.INSTANCE.getBuildNumber());
        config.setTreatDeprecatedPackagesAsPublic(this.treatDeprecatedPackagesAsPublic());
        config.setPackageVersions(this.loadPackageVersions());
        PackageScannerConfigurationYamlReader.populatePackages(config, this.packageExportsResource, this.publicApiResource);
        return config;
    }

    boolean treatDeprecatedPackagesAsPublic() {
        return Optional.ofNullable(System.getProperty("confluence.osgi.treatDeprecatedPackagesAsPublic")).map(Boolean::valueOf).orElseGet(() -> {
            if (ConfluenceSystemProperties.isDevMode()) {
                log.warn("Dev mode is enabled - all deprecated Confluence Java packages will be unavailable to non-bundled plugins");
                return false;
            }
            return true;
        });
    }

    private Map<String, String> loadPackageVersions() throws IOException {
        ImmutableMap versions = Maps.fromProperties((Properties)PropertiesLoaderUtils.loadProperties((Resource)this.packageVersionsResource));
        versions.forEach((key, value) -> Preconditions.checkState((!value.startsWith("$") ? 1 : 0) != 0, (String)"Unresolved version placeholder in %s for key %s", (Object)this.packageVersionsResource, (Object)key));
        return versions;
    }
}

