/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup;

import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;

final class PackageScannerConfigurationYamlReader {
    private static final Pattern NO_TRAILING_PERIOD = Pattern.compile(".*[^.]\\*");

    PackageScannerConfigurationYamlReader() {
    }

    static void populatePackages(DefaultPackageScannerConfiguration config, Resource packageExportsYaml, Resource publicApiYaml) throws IOException {
        Map<String, List<String>> exports = PackageScannerConfigurationYamlReader.transformPackageExportsYaml(PackageScannerConfigurationYamlReader.readYaml(packageExportsYaml));
        Map<String, List<String>> publicApi = PackageScannerConfigurationYamlReader.transformPublicApiYaml(PackageScannerConfigurationYamlReader.readYaml(publicApiYaml));
        config.setPackageIncludes(PackageScannerConfigurationYamlReader.extractList(exports, "includes"));
        config.setPackageExcludes(PackageScannerConfigurationYamlReader.extractList(exports, "excludes"));
        config.setOsgiPublicPackages(PackageScannerConfigurationYamlReader.extractSet(publicApi, "includes"));
        config.setOsgiPublicPackagesExcludes(PackageScannerConfigurationYamlReader.extractSet(publicApi, "excludes"));
        config.setDeprecatedPackages(PackageScannerConfigurationYamlReader.extractSet(publicApi, "deprecated"));
        config.setApplicationBundledInternalPlugins(PackageScannerConfigurationYamlReader.extractSet(publicApi, "internal-bundles"));
    }

    private static List<String> extractList(Map<String, List<String>> exports, String key) {
        return PackageScannerConfigurationYamlReader.getValues(exports, key).collect(Collectors.toList());
    }

    private static Set<String> extractSet(Map<String, List<String>> exports, String key) {
        return PackageScannerConfigurationYamlReader.getValues(exports, key).collect(Collectors.toSet());
    }

    private static Stream<String> getValues(Map<String, List<String>> exports, String key) {
        return Objects.requireNonNull(exports.get(key), key).stream().filter(StringUtils::isNotBlank).distinct().sorted();
    }

    private static Map<String, List<String>> readYaml(Resource resource) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            Map map = (Map)new Yaml().load((Reader)reader);
            return map;
        }
    }

    private static Map<String, List<String>> transformPackageExportsYaml(Map<String, List<String>> packageExports) {
        Map<String, List<String>> transformed = packageExports.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
        packageExports.forEach((key, value) -> value.stream().filter(v -> v.endsWith(".*")).map(v -> v.substring(0, v.length() - 2)).forEach(v -> ((List)transformed.get(key)).add(v)));
        return transformed;
    }

    private static Map<String, List<String>> transformPublicApiYaml(Map<String, List<String>> publicApi) {
        Map<String, List<String>> transformed = publicApi.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
        publicApi.forEach((key, value) -> value.stream().filter(v -> NO_TRAILING_PERIOD.matcher((CharSequence)v).matches()).map(v -> v.substring(0, v.length() - 1) + ".*").forEach(v -> ((List)transformed.get(key)).add(v)));
        return transformed;
    }
}

