/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup;

import com.atlassian.confluence.plugin.BundledPluginLoaderFactory;
import com.atlassian.confluence.plugin.ConfluenceApplication;
import com.atlassian.confluence.plugin.PluginDirectoryProvider;
import com.atlassian.confluence.plugin.SimplePluginDirectoryProvider;
import com.atlassian.confluence.setup.TempPluginParentDirectoryLocator;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.plugin.factories.LegacyDynamicPluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.container.impl.DefaultOsgiPersistentCache;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.factory.RemotablePluginFactory;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.spring.AvailableToPlugins;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ContextResource;

@Configuration
class SetupBundledPluginLoaderConfiguration {
    @Resource
    private PackageScannerConfiguration packageScannerConfiguration;
    @Resource
    private HostComponentProvider hostComponentProvider;
    @Resource
    private ServletContext servletContext;
    @Value(value="/WEB-INF/osgi-framework-bundles")
    private ContextResource frameworkBundlesLocation;

    SetupBundledPluginLoaderConfiguration() {
    }

    @Bean
    PluginLoader setupBundledPluginLoader() throws Exception {
        BundledPluginLoaderFactory factory = new BundledPluginLoaderFactory("atlassian-bundled-plugins-setup", this.setupPluginDirectoryProvider(), List.of(new LegacyDynamicPluginFactory("atlassian-plugin.xml", this.setupPluginDirectoryProvider().getPluginTempDirectory()), new OsgiPluginFactory("atlassian-plugin.xml", Set.copyOf(ConfluenceApplication.getConfluenceApplications()), this.setupOsgiPersistentCache(), (OsgiContainerManager)this.setupOsgiContainerManager(), this.setupPluginEventManager()), new OsgiBundleFactory("atlassian-plugin.xml", (OsgiContainerManager)this.setupOsgiContainerManager()), new RemotablePluginFactory("atlassian-plugin.xml", Set.copyOf(ConfluenceApplication.getConfluenceApplications()), (OsgiContainerManager)this.setupOsgiContainerManager(), this.setupPluginEventManager())), this.setupPluginEventManager());
        factory.setServletContext(this.servletContext);
        return factory.getObject();
    }

    @Bean(destroyMethod="clearExportCache")
    FelixOsgiContainerManager setupOsgiContainerManager() throws IOException {
        return new FelixOsgiContainerManager(this.frameworkBundlesLocation.getFile(), this.setupOsgiPersistentCache(), this.packageScannerConfiguration, this.hostComponentProvider, this.setupPluginEventManager());
    }

    @Bean
    OsgiPersistentCache setupOsgiPersistentCache() {
        return new DefaultOsgiPersistentCache(this.setupPluginDirectoryProvider().getPluginsPersistentCacheDirectory());
    }

    @Bean
    PluginDirectoryProvider setupPluginDirectoryProvider() {
        return new SimplePluginDirectoryProvider(new TempPluginParentDirectoryLocator());
    }

    @Bean
    @AvailableToPlugins
    PluginEventManager setupPluginEventManager() {
        return new DefaultPluginEventManager();
    }
}

