/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup.johnson;

import com.atlassian.confluence.impl.i18n.DefaultI18NBeanFactory;
import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.Lazy;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

final class DynamicI18NBeanFactory
implements I18NBeanFactory {
    private static final String USER_I18N_BEAN_FACTORY_REF = "userI18NBeanFactory";
    private static final String I18N_BEAN_FACTORY_REF = "i18NBeanFactory";
    private final @NonNull Supplier<I18NBeanFactory> delegateI18NBeanFactory;
    private final Supplier<Optional<BeanFactory>> setupBeanFactorySupplier;

    @VisibleForTesting
    public DynamicI18NBeanFactory(Supplier<Optional<BeanFactory>> setupBeanFactorySupplier) {
        this.setupBeanFactorySupplier = setupBeanFactorySupplier;
        this.delegateI18NBeanFactory = Lazy.supplier(() -> this.getTrappingExceptions(USER_I18N_BEAN_FACTORY_REF, I18NBeanFactory.class).orElse(this.getTrappingExceptions(I18N_BEAN_FACTORY_REF, I18NBeanFactory.class).orElseGet(DefaultI18NBeanFactory::createMinimal)));
    }

    public DynamicI18NBeanFactory() {
        this(() -> SetupContext.isAvailable() ? Optional.of(SetupContext.get().getBeanFactory()) : Optional.empty());
    }

    private <T> Optional<T> getTrappingExceptions(String beanName, Class<T> beanClass) {
        try {
            if (ContainerManager.isContainerSetup()) {
                return Optional.of(ContainerManager.getComponent((String)beanName, beanClass));
            }
            return this.setupBeanFactorySupplier.get().map(c -> Optional.of(c.getBean(beanName, beanClass))).orElseGet(Optional::empty);
        }
        catch (ComponentNotFoundException | IllegalStateException | NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    private @NonNull I18NBeanFactory getI18NBeanFactory() {
        return Objects.requireNonNull(this.delegateI18NBeanFactory.get());
    }

    public @NonNull I18NBean getI18NBean(@NonNull Locale locale) {
        return this.getI18NBeanFactory().getI18NBean(locale);
    }

    public @NonNull I18NBean getI18NBean() {
        return this.getI18NBeanFactory().getI18NBean();
    }

    public @NonNull String getStateHash() {
        return this.getI18NBeanFactory().getStateHash();
    }
}

