/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.event.events.analytics.HttpRequestStats;
import com.atlassian.confluence.impl.sitemesh.ConfluencePageDecorator;
import com.atlassian.confluence.impl.sitemesh.DecoratablePage;
import com.atlassian.confluence.impl.sitemesh.DecoratorActionFactory;
import com.atlassian.confluence.impl.sitemesh.DecoratorSpaceLocator;
import com.atlassian.confluence.impl.sitemesh.DecoratorTimings;
import com.atlassian.confluence.impl.sitemesh.DecoratorVelocityContextPopulator;
import com.atlassian.confluence.impl.sitemesh.ErrorHandlingStrategy;
import com.atlassian.confluence.impl.sitemesh.ResponseWritingStrategy;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.setup.struts.ConfluenceStrutsVelocityContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeContext;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.function.Supplier;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.context.Context;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionTemplate;

public class ConfluenceSitemeshDecorator
implements ConfluencePageDecorator {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSitemeshDecorator.class);
    public static final String HTTP_REQUEST_ATTR_KEY_WEB_INTERFACE_CONTEXT = "atlas.webInterfaceContext";
    public static final boolean BUFFER_RESPONSE = Boolean.getBoolean("confluence.sitemesh.response.buffer");
    static final ErrorHandlingStrategy ERROR_SENDING_STRATEGY = new ErrorHandlingStrategy.ErrorSendingErrorHandlingStrategy();
    static final ErrorHandlingStrategy ERROR_THROWING_STRATEGY = new ErrorHandlingStrategy.ErrorThrowingErrorHandlingStrategy();
    public static final String CONFLUENCE_SITEMESH_DECORATOR_ATTRIBUTE = "com.atlassian.confluence.util.profiling.ConfluenceSitemeshDecorator";
    static final String SPACE_ID_KEY = "meta.spaceid";
    private final String name;
    private final URI templateUri;
    private final ResponseWritingStrategy writingStrategy;
    private final ThemeManager themeManager;
    private final DecoratorSpaceLocator spaceLocator;
    private final VelocityManager velocityManager;
    private final Supplier<PlatformTransactionManager> platformTransactionManagerSupplier = MemoizingComponentReference.containerComponent("transactionManager");

    ConfluenceSitemeshDecorator(String decoratorName, URI templateUri, @Nullable ThemeManager themeManager, @Nullable SpaceManagerInternal spaceManager, VelocityManager velocityManager) {
        this(decoratorName, templateUri, themeManager, spaceManager, ERROR_SENDING_STRATEGY, velocityManager);
    }

    ConfluenceSitemeshDecorator(String decoratorName, URI templateUri, @Nullable ThemeManager themeManager, @Nullable SpaceManagerInternal spaceManager, ErrorHandlingStrategy errorHandlingStrategy, VelocityManager velocityManager) {
        this.themeManager = themeManager;
        this.name = decoratorName;
        this.templateUri = templateUri;
        this.writingStrategy = BUFFER_RESPONSE ? new ResponseWritingStrategy.StaticBufferedResponseWritingStrategy(errorHandlingStrategy) : new ResponseWritingStrategy.StreamingResponseWritingStrategy(errorHandlingStrategy);
        this.spaceLocator = new DecoratorSpaceLocator(spaceManager);
        this.velocityManager = velocityManager;
    }

    private PlatformTransactionManager getPTManager() {
        return this.platformTransactionManagerSupplier.get();
    }

    public String getName() {
        return this.name;
    }

    public void render(DecoratablePage page, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute(CONFLUENCE_SITEMESH_DECORATOR_ATTRIBUTE, (Object)true);
        String profileName = "SiteMesh: applyDecorator: %s (%s)".formatted(this.getName(), this.templateUri);
        try (DecoratorTimings.DecoratorTimer timer = DecoratorTimings.newDecoratorTimer((String)this.getName(), (HttpServletRequest)request);
             Ticker ignored = Timers.start((String)profileName);){
            if (ContainerManager.isContainerSetup()) {
                new TransactionTemplate(this.getPTManager()).execute(status -> {
                    try {
                        this.renderInternal(page, request, response);
                        return null;
                    }
                    catch (Exception ex) {
                        Throwables.throwIfInstanceOf((Throwable)ex, RuntimeException.class);
                        throw new UncheckedExecutionException((Throwable)ex);
                    }
                });
            } else {
                this.renderInternal(page, request, response);
            }
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), ServletException.class);
            throw e;
        }
        catch (TransactionException ex) {
            log.warn("TransactionException prevented transaction from committing whilst rendering the decorator, the cause is likely a previously logged exception: {}\nCause: {}", (Object)ex.getMessage(), (Object)(ex.getCause() != null ? ex.getCause().getMessage() : ""));
            log.debug("Full Details: ", (Throwable)ex);
        }
    }

    protected void renderInternal(DecoratablePage page, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.applyDecorator(page, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDecorator(DecoratablePage page, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Preconditions.checkState((ActionContext.getContext() != null ? 1 : 0) != 0, (Object)"Struts has not been initialized on this thread");
        HttpRequestStats.elapse("sitemeshDecoratorApplyStarted");
        HttpServletRequest originalRequest = ServletActionContext.getRequest();
        HttpServletResponse originalResponse = ServletActionContext.getResponse();
        ServletActionContext.setRequest((HttpServletRequest)request);
        ServletActionContext.setResponse((HttpServletResponse)response);
        try {
            this.applyDecoratorUsingVelocity(request, page, response);
        }
        finally {
            ServletActionContext.setRequest((HttpServletRequest)originalRequest);
            ServletActionContext.setResponse((HttpServletResponse)originalResponse);
            HttpRequestStats.elapse("sitemeshDecoratorApplyFinished");
        }
    }

    private void applyDecoratorUsingVelocity(HttpServletRequest request, DecoratablePage page, HttpServletResponse response) throws ServletException, IOException {
        if (!response.isCommitted()) {
            response.setHeader("X-Accel-Buffering", "no");
        }
        WebInterfaceContext webInterfaceContext = (WebInterfaceContext)request.getAttribute(HTTP_REQUEST_ATTR_KEY_WEB_INTERFACE_CONTEXT);
        Space space = this.spaceLocator.findSpaceForDecorating(webInterfaceContext, page).orElse(null);
        ConfluenceActionSupport action = DecoratorActionFactory.createAction(webInterfaceContext, space);
        if (space != null && !ThemeContext.hasThemeContext((ServletRequest)request)) {
            ThemeContext.set((ServletRequest)request, space, this.getActiveTheme(space.getKey()), this.getGlobalTheme());
        }
        Context context = this.velocityManager.createContext(ActionContext.getContext().getValueStack(), request, response);
        new DecoratorVelocityContextPopulator(this.themeManager).populateVelocityContext(request, space, page, action, this, context);
        if (context instanceof ConfluenceStrutsVelocityContext) {
            ConfluenceStrutsVelocityContext confluenceContext = (ConfluenceStrutsVelocityContext)context;
            confluenceContext.setOutputMimeType("text/html");
        }
        this.writingStrategy.renderToResponse(this.templateUri, context, response);
    }

    private Theme getActiveTheme(String spaceKey) {
        return this.themeManager == null ? null : this.themeManager.getSpaceTheme(spaceKey);
    }

    private Theme getGlobalTheme() {
        return this.themeManager == null ? null : this.themeManager.getGlobalTheme();
    }
}

