/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.impl.core.persistence.hibernate.ExceptionMonitorPredicates;
import com.atlassian.confluence.impl.sitemesh.ConfluenceSitemeshDecorator;
import com.atlassian.confluence.impl.sitemesh.DecoratablePage;
import com.atlassian.confluence.servlet.ServletRequestAttributes;
import com.atlassian.confluence.themes.ThemeManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Objects;
import org.apache.struts2.views.velocity.VelocityManager;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSitemeshErrorDecorator
extends ConfluenceSitemeshDecorator {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSitemeshErrorDecorator.class);

    ConfluenceSitemeshErrorDecorator(String decoratorName, URI templateUri, @Nullable ThemeManager themeManager, @Nullable SpaceManagerInternal spaceManager, VelocityManager velocityManager) {
        super(decoratorName, templateUri, themeManager, spaceManager, ERROR_THROWING_STRATEGY, velocityManager);
    }

    @Override
    public void render(DecoratablePage page, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.shouldBypassDecorator(request)) {
            log.warn("Bypassing error page decorator");
            this.renderNoDecorator(page, response);
        } else {
            super.render(page, request, response);
        }
    }

    @Override
    protected void renderInternal(DecoratablePage page, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.applyDecorator(page, request, response);
        }
        catch (Exception e) {
            log.error("Failed to render error decorator. Falling back to using no decorator", (Throwable)e);
            this.renderNoDecorator(page, response);
        }
    }

    void renderNoDecorator(DecoratablePage page, HttpServletResponse response) throws IOException {
        page.writePage((Writer)response.getWriter());
    }

    private boolean shouldBypassDecorator(HttpServletRequest request) {
        return ConfluenceSitemeshErrorDecorator.isHttp500Error(request) && ExceptionMonitorPredicates.shortCircuitRequestTester().test(request);
    }

    private static boolean isHttp500Error(HttpServletRequest request) {
        return Objects.equals(ServletRequestAttributes.getErrorStatusCode((ServletRequest)request), 500);
    }
}

