/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.confluence.setup.velocity.DecoratorName;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeContext;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.themes.ThemedDecorator;
import com.atlassian.confluence.util.HtmlUtil;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.views.velocity.VelocityManager;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConfluenceSpaceDecoratorMapper
extends AbstractDecoratorMapper {
    private static final DecoratorName HACK_NULL_DECORATOR = new DecoratorName(null, "");
    private final ThemeManager themeManager;
    private final VelocityManager velocityManager;

    public ConfluenceSpaceDecoratorMapper(ThemeManager themeManager, VelocityManager velocityManager) {
        this.themeManager = themeManager;
        this.velocityManager = velocityManager;
    }

    public @Nullable Decorator getNamedDecorator(HttpServletRequest request, String decoratorName) {
        Decorator parentDecorator = super.getNamedDecorator(request, decoratorName);
        Decorator decorator = this.getDecorator(parentDecorator, request);
        if (decorator == null || decorator.getName().equals(decoratorName)) {
            return decorator;
        }
        return parentDecorator;
    }

    public @Nullable Decorator getDecorator(HttpServletRequest httpServletRequest, Page page) {
        Decorator parentDecorator = this.parent.getDecorator(httpServletRequest, page);
        return this.getDecorator(parentDecorator, httpServletRequest);
    }

    private @Nullable Decorator getDecorator(Decorator parentDecorator, HttpServletRequest request) {
        if (!StringUtils.isNotEmpty((CharSequence)parentDecorator.getPage())) {
            return parentDecorator;
        }
        ThemeContext themeContext = ThemeContext.get((ServletRequest)request);
        DecoratorName decorator = null;
        if (themeContext.hasSpaceTheme()) {
            decorator = this.getThemeDecorator(themeContext.getSpaceTheme(), parentDecorator, request);
        }
        if (decorator == null) {
            decorator = this.getSpaceCustomDecorator(parentDecorator, themeContext.getSpaceKey());
        }
        if (decorator == null && themeContext.hasGlobalTheme()) {
            decorator = this.getThemeDecorator(themeContext.getGlobalTheme(), parentDecorator, request);
        }
        if (decorator == null) {
            decorator = this.getThemeDecorator(this.themeManager.getGlobalTheme(), parentDecorator, request);
        }
        if (decorator == null) {
            return parentDecorator;
        }
        if (decorator == HACK_NULL_DECORATOR) {
            return null;
        }
        return new DefaultDecorator(parentDecorator.getName(), decorator.getSource(), null);
    }

    private @Nullable DecoratorName getSpaceCustomDecorator(Decorator parentDecorator, String spaceKey) {
        String decoratorPage = parentDecorator.getPage();
        DecoratorName decoratorName = new DecoratorName(spaceKey, decoratorPage);
        if (!Space.isValidSpaceKey(spaceKey)) {
            return null;
        }
        if (!this.velocityManager.getVelocityEngine().resourceExists(decoratorName.getSource())) {
            return null;
        }
        return decoratorName;
    }

    private @Nullable DecoratorName getThemeDecorator(@Nullable Theme theme, Decorator parentDecorator, HttpServletRequest request) {
        if (theme == null) {
            return null;
        }
        if (theme.isDisableSitemesh()) {
            return HACK_NULL_DECORATOR;
        }
        ThemedDecorator themedDecorator = theme.getDecorator(parentDecorator.getPage());
        if (themedDecorator == null) {
            return null;
        }
        request.setAttribute("theme.resource.path", (Object)("/download/resources/" + HtmlUtil.urlEncode(themedDecorator.getResourceKey()) + "/"));
        DecoratorName decorator = themedDecorator.getDecorator();
        if (decorator != null) {
            return new DecoratorName(null, decorator.getTemplateName());
        }
        return null;
    }
}

