/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.impl.sitemesh.DecoratorAction;
import com.atlassian.confluence.impl.sitemesh.SpaceDecoratorAction;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.languages.LocaleParser;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceActionForDecorating;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.spring.container.ContainerManager;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DecoratorActionFactory {
    public static ConfluenceActionSupport createAction(@Nullable WebInterfaceContext webInterfaceContext, @Nullable Space space) {
        if (webInterfaceContext != null && ContainerManager.isContainerSetup()) {
            ConfluenceActionSupport action = space == null ? new DecoratorAction(webInterfaceContext) : new SpaceDecoratorAction(webInterfaceContext, space);
            ContainerManager.autowireComponent((Object)action);
            return action;
        }
        return DecoratorActionFactory.newWiredConfluenceActionSupport(space);
    }

    private static ConfluenceActionSupport newWiredConfluenceActionSupport(@Nullable Space space) {
        ConfluenceActionSupport dummy;
        ConfluenceActionSupport confluenceActionSupport = dummy = space == null ? new ConfluenceActionSupport() : new SpaceActionForDecorating(space);
        if (ContainerManager.isContainerSetup()) {
            ContainerManager.autowireComponent((Object)dummy);
        } else if (ServletContextThreadLocal.getRequest() != null && SetupContext.get() != null) {
            dummy = new SetupLocaleDummyWiredAction();
        }
        return dummy;
    }

    private static final class SetupLocaleDummyWiredAction
    extends ConfluenceActionSupport {
        private SetupLocaleDummyWiredAction() {
        }

        @Override
        public Locale getLocale() {
            ApplicationConfiguration applicationConfig = (ApplicationConfiguration)SetupContext.get().getBean(ApplicationConfiguration.class);
            String localeString = (String)applicationConfig.getProperty((Object)"confluence.setup.locale");
            if (localeString != null) {
                return LocaleParser.toLocale(localeString);
            }
            return LocaleManager.DEFAULT_LOCALE;
        }
    }
}

