/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.impl.sitemesh.DecoratablePage;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.spaces.Space;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DecoratorSpaceLocator {
    private static final Logger log = LoggerFactory.getLogger(DecoratorSpaceLocator.class);
    private final SpaceManagerInternal spaceManager;

    DecoratorSpaceLocator(@Nullable SpaceManagerInternal spaceManager) {
        this.spaceManager = spaceManager;
    }

    @VisibleForTesting
    Optional<Space> findSpaceForDecorating(@Nullable WebInterfaceContext webInterfaceContext, DecoratablePage page) {
        Space space = Optional.ofNullable(webInterfaceContext).map(WebInterfaceContext::getSpace).orElse(null);
        if (space == null && this.spaceManager != null) {
            String spaceId = page.getProperty("meta.spaceid");
            space = Optional.ofNullable(spaceId).map(spaceIdString -> {
                try {
                    return Long.parseLong(spaceIdString);
                }
                catch (NumberFormatException nfe) {
                    log.warn("Invalid spaceId", (Throwable)nfe);
                    return null;
                }
            }).map(this.spaceManager::getSpace).orElse(null);
        }
        return Optional.ofNullable(space);
    }
}

