/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.impl.sitemesh.ConfluencePageDecorator;
import com.atlassian.confluence.impl.sitemesh.DecoratablePage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.velocity.context.Context;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DecoratorVelocityContextPopulator {
    private final ThemeManager themeManager;

    DecoratorVelocityContextPopulator(@Nullable ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    void populateVelocityContext(HttpServletRequest request, @Nullable Space space, DecoratablePage page, ConfluenceActionSupport action, ConfluencePageDecorator decorator, Context context) {
        String spaceKey;
        if (!context.containsKey((Object)"staticResourceUrlPrefix")) {
            context.put("staticResourceUrlPrefix", (Object)request.getContextPath());
        }
        context.put("action", (Object)action);
        context.put("helper", (Object)action.getHelper());
        context.put("sitemeshPage", (Object)page);
        context.put("username", (Object)page.getProperty("page.username"));
        if (space != null) {
            context.put("space", (Object)space);
            spaceKey = space.getKey();
        } else {
            spaceKey = page.getProperty("page.spacekey");
        }
        context.put("spaceKey", (Object)spaceKey);
        context.put("theme", this.themeManager == null ? null : this.themeManager.getSpaceTheme(spaceKey));
        context.put("body", (Object)page.renderableBody());
        context.put("decorator", (Object)decorator);
        context.put("head", (Object)page.renderableHead());
        context.put("title", (Object)new HtmlFragment((Object)page.getTitle()));
    }
}

