/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.confluence.impl.sitemesh.ErrorHandlingStrategy;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface ResponseWritingStrategy {
    public void renderToResponse(URI var1, Context var2, HttpServletResponse var3) throws ServletException, IOException;

    public static final class StreamingResponseWritingStrategy
    implements ResponseWritingStrategy {
        private static final Logger log = LoggerFactory.getLogger(StreamingResponseWritingStrategy.class);
        private final ErrorHandlingStrategy errorHandlingStrategy;

        StreamingResponseWritingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = errorHandlingStrategy;
        }

        @Override
        public void renderToResponse(URI templateUri, Context context, HttpServletResponse response) throws ServletException, IOException {
            try {
                VelocityUtils.renderTemplateWithoutSwallowingErrors(templateUri.toString(), context, (Writer)response.getWriter());
            }
            catch (Exception e) {
                if (response.isCommitted()) {
                    response.getWriter().printf("Error occurred during template rendering. Contact your administrator for assistance.", new Object[0]);
                    log.error("Error occurred rendering template: {}", (Object)templateUri, (Object)e);
                }
                this.errorHandlingStrategy.handleException(e, response);
            }
        }
    }

    public static final class StaticBufferedResponseWritingStrategy
    implements ResponseWritingStrategy {
        private final ErrorHandlingStrategy errorHandlingStrategy;

        StaticBufferedResponseWritingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = errorHandlingStrategy;
        }

        @Override
        public void renderToResponse(URI templateUri, Context context, HttpServletResponse response) throws ServletException, IOException {
            try {
                String template = VelocityUtils.getRenderedTemplateWithoutSwallowingErrors(templateUri.toString(), context);
                response.getWriter().write(template);
            }
            catch (Exception e) {
                this.errorHandlingStrategy.handleException(e, response);
            }
        }
    }
}

